/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mps;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.blockshot.repack.org.jcodec.common.IntIntMap;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.tools.MainUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mps.MTSStreamType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mps.MTSUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mps.psi.PATSection;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mps.psi.PSISection;

public class MTSReplacePid
extends MTSUtils.TSReader {
    private Set<Integer> pmtPids = new HashSet<Integer>();
    private IntIntMap replaceSpec;

    public MTSReplacePid(IntIntMap replaceSpec) {
        super(true);
        this.replaceSpec = replaceSpec;
    }

    @Override
    public boolean onPkt(int guid, boolean payloadStart, ByteBuffer tsBuf, long filePos, boolean sectionSyntax, ByteBuffer fullPkt) {
        if (sectionSyntax) {
            this.replaceRefs(this.replaceSpec, guid, tsBuf, this.pmtPids);
        } else {
            System.out.print("TS ");
            ByteBuffer buf = fullPkt.duplicate();
            short tsFlags = buf.getShort(buf.position() + 1);
            buf.putShort(buf.position() + 1, (short)(this.replacePid(this.replaceSpec, tsFlags & 0x1FFF) | tsFlags & 0xFFFFE000));
        }
        return true;
    }

    private static IntIntMap parseReplaceSpec(String spec) {
        IntIntMap map = new IntIntMap();
        for (String pidPair : spec.split(",")) {
            String[] pidPairParsed = pidPair.split(":");
            map.put(Integer.parseInt(pidPairParsed[0]), Integer.parseInt(pidPairParsed[1]));
        }
        return map;
    }

    private void replaceRefs(IntIntMap replaceSpec, int guid, ByteBuffer buf, Set<Integer> pmtPids) {
        block3: {
            block2: {
                if (guid != 0) break block2;
                PATSection pat = PATSection.parsePAT(buf);
                for (int pids : pat.getPrograms().values()) {
                    pmtPids.add(pids);
                }
                break block3;
            }
            if (!pmtPids.contains(guid)) break block3;
            System.out.println(MainUtils.bold("PMT"));
            PSISection.parsePSI(buf);
            buf.getShort();
            NIOUtils.skip(buf, buf.getShort() & 0xFFF);
            while (buf.remaining() > 4) {
                byte streamType = buf.get();
                MTSStreamType fromTag = MTSStreamType.fromTag(streamType);
                System.out.print((fromTag == null ? "UNKNOWN" : fromTag) + "(" + String.format("0x%02x", streamType) + "):\t");
                int wn = buf.getShort() & 0xFFFF;
                int wasPid = wn & 0x1FFF;
                int elementaryPid = this.replacePid(replaceSpec, wasPid);
                buf.putShort(buf.position() - 2, (short)(elementaryPid & 0x1FFF | wn & 0xFFFFE000));
                NIOUtils.skip(buf, buf.getShort() & 0xFFF);
            }
        }
    }

    private int replacePid(IntIntMap replaceSpec, int pid) {
        int newPid = pid;
        if (replaceSpec.contains(pid)) {
            newPid = replaceSpec.get(pid);
        }
        System.out.println("[" + pid + "->" + newPid + "]");
        return newPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main1(String[] args) throws IOException {
        MainUtils.Cmd cmd = MainUtils.parseArguments(args, new MainUtils.Flag[0]);
        if (cmd.args.length < 2) {
            MainUtils.printHelpNoFlags("pid_from:pid_to,[pid_from:pid_to...]", "file");
            return;
        }
        IntIntMap replaceSpec = MTSReplacePid.parseReplaceSpec(cmd.getArg(0));
        FileChannelWrapper ch = null;
        try {
            ch = NIOUtils.rwChannel(new File(cmd.getArg(1)));
            new MTSReplacePid(replaceSpec).readTsFile(ch);
        }
        catch (Throwable throwable) {
            NIOUtils.closeQuietly(ch);
            throw throwable;
        }
        NIOUtils.closeQuietly(ch);
    }
}

