/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.common.Format;
import net.creeperhost.blockshot.repack.org.jcodec.common.JCodecUtil;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MetaBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MetaValue;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.UdtaBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.UdtaMetaBox;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.MP4Edit;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.RelocateMP4Editor;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.ReplaceMP4Editor;

public class MetadataEditor {
    private File source;
    private MovieEditor movieEditor;

    public MetadataEditor(File source, MovieEditor movieEditor) {
        this.source = source;
        this.movieEditor = movieEditor;
    }

    public static MetadataEditor createFrom(File f) throws IOException {
        Format format = JCodecUtil.detectFormat(f);
        if (format != Format.MOV) {
            throw new IllegalArgumentException("Unsupported format: " + format);
        }
        MP4Util.Movie movie = MP4Util.parseFullMovie(f);
        return new MetadataEditor(f, MovieEditor.createFromMovie(movie.getMoov()));
    }

    public void save(boolean fast) throws IOException {
        MetadataEditor self = this;
        MP4Edit edit = new MP4Edit(){

            @Override
            public void applyToFragment(MovieBox mov, MovieFragmentBox[] fragmentBox) {
            }

            @Override
            public void apply(MovieBox movie) {
                MetadataEditor.this.movieEditor.apply(movie);
            }
        };
        if (fast) {
            new RelocateMP4Editor().modifyOrRelocate(this.source, edit);
        } else {
            new ReplaceMP4Editor().modifyOrReplace(this.source, edit);
        }
    }

    public File getSource() {
        return this.source;
    }

    public MovieEditor getMovieEditor() {
        return this.movieEditor;
    }

    public Map<Integer, MetaValue> getItunesMeta() {
        return this.movieEditor.getItunesMeta();
    }

    public Map<String, MetaValue> getKeyedMeta() {
        return this.movieEditor.getKeyedMeta();
    }

    public Map<Integer, MetaValue> getUdata() {
        return this.movieEditor.getUdata();
    }

    public static class MovieEditor {
        private Map<String, MetaValue> keyedMeta;
        private Map<Integer, MetaValue> itunesMeta;
        private Map<Integer, MetaValue> udata;

        public MovieEditor(Map<String, MetaValue> keyedMeta, Map<Integer, MetaValue> itunesMeta, Map<Integer, MetaValue> udata) {
            this.keyedMeta = keyedMeta;
            this.itunesMeta = itunesMeta;
            this.udata = udata;
        }

        public static MovieEditor createFromMovie(MovieBox moov) {
            MetaBox keyedMeta = NodeBox.findFirst(moov, MetaBox.class, MetaBox.fourcc());
            MetaBox itunesMeta = NodeBox.findFirstPath(moov, MetaBox.class, new String[]{"udta", MetaBox.fourcc()});
            UdtaBox udtaBox = NodeBox.findFirst(moov, UdtaBox.class, "udta");
            return new MovieEditor(keyedMeta == null ? new HashMap() : keyedMeta.getKeyedMeta(), itunesMeta == null ? new HashMap() : itunesMeta.getItunesMeta(), udtaBox == null ? new HashMap() : udtaBox.getMetadata());
        }

        public void apply(MovieBox movie) {
            boolean hasUdataMeta;
            MetaBox meta1 = NodeBox.findFirst(movie, MetaBox.class, MetaBox.fourcc());
            MetaBox meta2 = NodeBox.findFirstPath(movie, MetaBox.class, new String[]{"udta", MetaBox.fourcc()});
            if (this.keyedMeta != null && this.keyedMeta.size() > 0) {
                if (meta1 == null) {
                    meta1 = MetaBox.createMetaBox();
                    movie.add(meta1);
                }
                meta1.setKeyedMeta(this.keyedMeta);
            }
            boolean hasItunesMeta = this.itunesMeta != null && this.itunesMeta.size() > 0;
            boolean bl = hasUdataMeta = this.udata != null && this.udata.size() > 0;
            if (hasItunesMeta || hasUdataMeta) {
                UdtaBox udta = NodeBox.findFirst(movie, UdtaBox.class, "udta");
                if (meta2 == null) {
                    meta2 = UdtaMetaBox.createUdtaMetaBox();
                    if (udta == null) {
                        udta = UdtaBox.createUdtaBox();
                        movie.add(udta);
                    }
                    udta.add(meta2);
                }
                if (hasItunesMeta) {
                    meta2.setItunesMeta(this.itunesMeta);
                }
                if (hasUdataMeta) {
                    udta.setMetadata(this.udata);
                }
            }
        }

        public Map<Integer, MetaValue> getItunesMeta() {
            return this.itunesMeta;
        }

        public Map<String, MetaValue> getKeyedMeta() {
            return this.keyedMeta;
        }

        public Map<Integer, MetaValue> getUdata() {
            return this.udata;
        }
    }
}

