/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.common.Tuple;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.RationalLarge;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Chunk;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.ChunkReader;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Edit;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class Strip {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main1(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Syntax: strip <ref movie> <out movie>");
            System.exit(-1);
        }
        Channel input = null;
        Channel out = null;
        try {
            input = NIOUtils.readableChannel(new File(args[0]));
            File file = new File(args[1]);
            Platform.deleteFile(file);
            out = NIOUtils.writableChannel(file);
            MP4Util.Movie movie = MP4Util.createRefFullMovie((SeekableByteChannel)input, "file://" + new File(args[0]).getAbsolutePath());
            new Strip().stripToChunks(movie.getMoov());
            MP4Util.writeFullMovie((SeekableByteChannel)out, movie);
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void strip(MovieBox movie) throws IOException {
        this.stripToChunks(movie);
        this.stripToSamples(movie, false);
    }

    public void stripToChunks(MovieBox movie) throws IOException {
        TrakBox[] tracks;
        RationalLarge maxDuration = RationalLarge.ZERO;
        for (TrakBox track : tracks = movie.getTracks()) {
            RationalLarge duration = this.stripTrack(movie, track);
            if (!duration.greaterThen(maxDuration)) continue;
            maxDuration = duration;
        }
        movie.setDuration(movie.rescale(maxDuration.getNum(), maxDuration.getDen()));
    }

    public void stripToSamples(MovieBox movie, boolean toWholeSampleMeta) throws IOException {
        TrakBox[] tracks;
        RationalLarge maxDuration = RationalLarge.ZERO;
        TrakBox[] trakBoxArray = tracks = movie.getTracks();
        int n = trakBoxArray.length;
        for (int i = 0; i < n; ++i) {
            TrakBox track;
            RationalLarge duration = this.trimEdits(movie, track, !"meta".equals((track = trakBoxArray[i]).getHandlerType()) || toWholeSampleMeta);
            if (!duration.greaterThen(maxDuration)) continue;
            maxDuration = duration;
        }
        movie.setDuration(movie.rescale(maxDuration.getNum(), maxDuration.getDen()));
    }

    public RationalLarge stripTrack(MovieBox movie, TrakBox track) throws IOException {
        Chunk chunk;
        ChunkReader chunks = new ChunkReader(track, null);
        List<Edit> edits = track.getEdits();
        List<Edit> oldEdits = this.deepCopy(edits);
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        while ((chunk = chunks.next()) != null) {
            boolean intersects = false;
            for (Edit edit : oldEdits) {
                long chunkE;
                long chunkS;
                long editE;
                long editS;
                if (edit.getMediaTime() != -1L && (intersects = Strip.intersects(editS = edit.getMediaTime(), editE = edit.getMediaTime() + track.rescale(edit.getDuration(), movie.getTimescale()), chunkS = chunk.getStartTv(), chunkE = chunk.getStartTv() + (long)chunk.getDuration()))) break;
            }
            if (!intersects) {
                for (int i = 0; i < oldEdits.size(); ++i) {
                    if (oldEdits.get(i).getMediaTime() < chunk.getStartTv() + (long)chunk.getDuration()) continue;
                    edits.get(i).shift(-chunk.getDuration());
                }
                continue;
            }
            result.add(chunk);
        }
        NodeBox stbl = NodeBox.findFirstPath(track, NodeBox.class, Box.path("mdia.minf.stbl"));
        stbl.replace("stts", this.getTimeToSamples(result));
        stbl.replace("stsz", this.getSampleSizes(result));
        stbl.replace("stsc", this.getSamplesToChunk(result));
        stbl.removeChildren(new String[]{"stco", "co64"});
        stbl.add(this.getChunkOffsets(result));
        long duration = this.totalDuration(result);
        MediaHeaderBox mdhd = NodeBox.findFirstPath(track, MediaHeaderBox.class, Box.path("mdia.mdhd"));
        mdhd.setDuration(duration);
        track.setDuration(movie.rescale(duration, mdhd.getTimescale()));
        return new RationalLarge(duration, mdhd.getTimescale());
    }

    /*
     * WARNING - void declaration
     */
    static List<Tuple._2<Long, Long>> findGaps(RationalLarge rescale, List<Edit> edits, Tuple._2<Long, Long> timeline) {
        ArrayList<Tuple._2<Long, Long>> intervals = new ArrayList<Tuple._2<Long, Long>>();
        intervals.add(timeline);
        for (Edit edit : edits) {
            if (edit.getMediaTime() == -1L) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            long editEnd = edit.getMediaTime() + rescale.multiplyS(edit.getDuration());
            for (Tuple._2 _22 : intervals) {
                void var10_12;
                Tuple._2 gap1;
                Tuple._2 gap0;
                if ((Long)_22.v0 <= edit.getMediaTime() && (Long)_22.v1 > edit.getMediaTime()) {
                    gap0 = new Tuple._2(_22.v0, edit.getMediaTime() - 1L);
                    gap1 = new Tuple._2(edit.getMediaTime(), _22.v1);
                    arrayList.add(gap0);
                    Tuple._2 _23 = gap1;
                }
                if ((Long)var10_12.v0 <= editEnd && (Long)var10_12.v1 > editEnd) {
                    gap0 = new Tuple._2(var10_12.v0, editEnd - 1L);
                    gap1 = new Tuple._2(editEnd, var10_12.v1);
                    arrayList.add(gap0);
                    arrayList.add(gap1);
                    continue;
                }
                arrayList.add(var10_12);
            }
            intervals = arrayList;
        }
        ArrayList<Tuple._2<Long, Long>> unclaimed = new ArrayList<Tuple._2<Long, Long>>();
        for (Tuple._2 _24 : intervals) {
            boolean claimed = false;
            for (Edit edit : edits) {
                if (edit.getMediaTime() == -1L) continue;
                long l = edit.getMediaTime() + rescale.multiplyS(edit.getDuration()) - 1L;
                if (((Long)_24.v0).longValue() != edit.getMediaTime() && (Long)_24.v1 != l) continue;
                claimed = true;
                break;
            }
            if (claimed) continue;
            unclaimed.add(_24);
        }
        return unclaimed;
    }

    static List<Chunk> cutChunksToGaps(List<Chunk> chunks, List<Tuple._2<Long, Long>> gaps, List<Tuple._2<Long, Long>> newIntervals) {
        ArrayList<Tuple._2<Long, Long>> newGaps = new ArrayList<Tuple._2<Long, Long>>();
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        long pullBack = 0L;
        Iterator<Chunk> it = chunks.iterator();
        while (it.hasNext()) {
            Chunk chunk = it.next();
            for (Tuple._2<Long, Long> _22 : gaps) {
                Tuple._2<Chunk, Chunk> split;
                if ((Long)_22.v0 > chunk.getStartTv() && (Long)_22.v0 < chunk.getStartTv() + (long)chunk.getDuration()) {
                    split = chunk.split((Long)_22.v0 - chunk.getStartTv(), true);
                    Chunk left = (Chunk)split.v0;
                    result.add(left);
                    long l = (Long)_22.v0 - chunk.getStartTv();
                    if (newIntervals != null) {
                        newGaps.add(new Tuple._2<Long, Long>((Long)_22.v0 - pullBack, (long)left.getDuration() - l));
                    } else {
                        left.trimLastSample((long)left.getDuration() - l);
                    }
                    chunk = (Chunk)split.v1;
                    while (chunk != null && (Long)_22.v1 >= chunk.getStartTv() + (long)chunk.getDuration()) {
                        pullBack += (long)chunk.getDuration();
                        chunk = it.hasNext() ? it.next() : null;
                    }
                    if (chunk != null && chunk.getSampleCount() == 0) {
                        chunk = null;
                    }
                }
                if (chunk == null) break;
                if ((Long)_22.v1 >= chunk.getStartTv() && (Long)_22.v1 < chunk.getStartTv() + (long)chunk.getDuration()) {
                    long trimDur;
                    split = chunk.split((Long)_22.v1 - chunk.getStartTv() + 1L, false);
                    long wantStart = (Long)_22.v1 + 1L;
                    long realStart = (long)((Chunk)split.v0).getDuration() + chunk.getStartTv();
                    pullBack += (long)((Chunk)split.v0).getDuration();
                    chunk = (Chunk)split.v1;
                    if (chunk != null && chunk.getSampleCount() == 0) {
                        chunk = null;
                    }
                    if ((trimDur = wantStart - realStart) != 0L) {
                        if (newIntervals != null) {
                            newGaps.add(new Tuple._2<Long, Long>(realStart - pullBack, trimDur));
                        } else {
                            ((Chunk)split.v1).trimFirstSample(trimDur);
                        }
                    }
                }
                if (chunk != null) continue;
                break;
            }
            if (chunk == null) continue;
            result.add(chunk);
        }
        long startTv = 0L;
        for (Chunk chunk : result) {
            chunk.setStartTv(startTv);
            startTv += (long)chunk.getDuration();
        }
        if (newIntervals != null) {
            long l = startTv;
            startTv = result.isEmpty() ? 0L : ((Chunk)result.get(0)).getStartTv();
            for (Tuple._2 _23 : newGaps) {
                if (startTv < (Long)_23.v0) {
                    newIntervals.add(new Tuple._2<Long, Long>(startTv, (Long)_23.v0 - startTv));
                }
                startTv = (Long)_23.v1 + (Long)_23.v0;
            }
            if (startTv < l) {
                newIntervals.add(new Tuple._2<Long, Long>(startTv, l - startTv));
            }
        }
        return result;
    }

    public RationalLarge trimEdits(MovieBox movie, TrakBox track, boolean toWholeSample) throws IOException {
        Edit firstEdit;
        Tuple._2<Long, Long> timeline;
        ChunkReader chunkReader = new ChunkReader(track, null);
        List<Edit> edits = track.getEdits();
        List<Chunk> chunks = chunkReader.readAll();
        if (!chunks.isEmpty()) {
            Chunk firstChunk = chunks.get(0);
            Chunk lastChunk = chunks.get(chunks.size() - 1);
            timeline = new Tuple._2<Long, Long>(firstChunk.getStartTv(), lastChunk.getStartTv() + (long)lastChunk.getDuration());
        } else {
            timeline = new Tuple._2<Long, Long>(0L, 0L);
        }
        List<Tuple._2<Long, Long>> gaps = Strip.findGaps(RationalLarge.R(track.getTimescale(), movie.getTimescale()), edits, timeline);
        ArrayList<Tuple._2<Long, Long>> newIntervals = new ArrayList<Tuple._2<Long, Long>>();
        List<Chunk> result = Strip.cutChunksToGaps(chunks, gaps, toWholeSample ? newIntervals : null);
        ArrayList<Edit> newEdits = new ArrayList<Edit>();
        if (toWholeSample) {
            for (Tuple._2 _22 : newIntervals) {
                newEdits.add(new Edit(movie.rescale((Long)_22.v1, track.getTimescale()), (Long)_22.v0, 1.0f));
            }
        } else if (result.size() > 0) {
            Chunk firstChunk = result.get(0);
            Chunk chunk = result.get(result.size() - 1);
            long start = firstChunk.getStartTv();
            long duration = chunk.getStartTv() + (long)chunk.getDuration();
            newEdits.add(new Edit(movie.rescale(duration, track.getTimescale()), start, 1.0f));
        }
        if (!edits.isEmpty() && (firstEdit = edits.get(0)).getMediaTime() == -1L) {
            newEdits.add(0, firstEdit);
        }
        track.setEdits(newEdits);
        NodeBox stbl = NodeBox.findFirstPath(track, NodeBox.class, Box.path("mdia.minf.stbl"));
        stbl.replace("stts", this.getTimeToSamples(result));
        stbl.replace("stsz", this.getSampleSizes(result));
        stbl.replace("stsc", this.getSamplesToChunk(result));
        stbl.removeChildren(new String[]{"stco", "co64"});
        stbl.add(this.getChunkOffsets(result));
        long l = this.totalDuration(result);
        MediaHeaderBox mdhd = NodeBox.findFirstPath(track, MediaHeaderBox.class, Box.path("mdia.mdhd"));
        mdhd.setDuration(l);
        track.setDuration(movie.rescale(l, mdhd.getTimescale()));
        return new RationalLarge(l, mdhd.getTimescale());
    }

    private long totalDuration(List<Chunk> result) {
        long duration = 0L;
        for (Chunk chunk : result) {
            duration += (long)chunk.getDuration();
        }
        return duration;
    }

    private List<Edit> deepCopy(List<Edit> edits) {
        ArrayList<Edit> newList = new ArrayList<Edit>();
        if (edits != null) {
            for (Edit edit : edits) {
                newList.add(Edit.createEdit(edit));
            }
        }
        return newList;
    }

    public Box getChunkOffsets(List<Chunk> chunks) {
        long[] result = new long[chunks.size()];
        boolean longBox = false;
        int i = 0;
        for (Chunk chunk : chunks) {
            if (chunk.getOffset() >= 0x100000000L) {
                longBox = true;
            }
            result[i++] = chunk.getOffset();
        }
        return longBox ? ChunkOffsets64Box.createChunkOffsets64Box(result) : ChunkOffsetsBox.createChunkOffsetsBox(result);
    }

    public TimeToSampleBox getTimeToSamples(List<Chunk> chunks) {
        ArrayList<TimeToSampleBox.TimeToSampleEntry> tts = new ArrayList<TimeToSampleBox.TimeToSampleEntry>();
        int curTts = -1;
        int cnt = 0;
        for (Chunk chunk : chunks) {
            if (chunk.getSampleDur() != -1) {
                if (curTts == -1 || curTts != chunk.getSampleDur()) {
                    if (curTts != -1) {
                        tts.add(new TimeToSampleBox.TimeToSampleEntry(cnt, curTts));
                    }
                    cnt = 0;
                    curTts = chunk.getSampleDur();
                }
                cnt += chunk.getSampleCount();
                continue;
            }
            for (int dur : chunk.getSampleDurs()) {
                if (curTts == -1 || curTts != dur) {
                    if (curTts != -1) {
                        tts.add(new TimeToSampleBox.TimeToSampleEntry(cnt, curTts));
                    }
                    cnt = 0;
                    curTts = dur;
                }
                ++cnt;
            }
        }
        if (cnt > 0) {
            tts.add(new TimeToSampleBox.TimeToSampleEntry(cnt, curTts));
        }
        return TimeToSampleBox.createTimeToSampleBox(tts.toArray(new TimeToSampleBox.TimeToSampleEntry[0]));
    }

    public SampleSizesBox getSampleSizes(List<Chunk> chunks) {
        int nSamples = 0;
        int prevSize = chunks.isEmpty() ? 0 : chunks.get(0).getSampleSize();
        for (Chunk chunk : chunks) {
            nSamples += chunk.getSampleCount();
            if (prevSize != 0 || chunk.getSampleSize() == 0) continue;
            throw new RuntimeException("Mixed sample sizes not supported");
        }
        if (prevSize > 0) {
            return SampleSizesBox.createSampleSizesBox(prevSize, nSamples);
        }
        int[] sizes2 = new int[nSamples];
        int startSample = 0;
        for (Chunk chunk : chunks) {
            System.arraycopy(chunk.getSampleSizes(), 0, sizes2, startSample, chunk.getSampleCount());
            startSample += chunk.getSampleCount();
        }
        return SampleSizesBox.createSampleSizesBox2(sizes2);
    }

    public SampleToChunkBox getSamplesToChunk(List<Chunk> chunks) {
        ArrayList<SampleToChunkBox.SampleToChunkEntry> result = new ArrayList<SampleToChunkBox.SampleToChunkEntry>();
        Iterator<Chunk> it = chunks.iterator();
        if (it.hasNext()) {
            Chunk chunk = it.next();
            int curSz = chunk.getSampleCount();
            int curEntry = chunk.getEntry();
            int first = 1;
            int cnt = 1;
            while (it.hasNext()) {
                chunk = it.next();
                int newSz = chunk.getSampleCount();
                int newEntry = chunk.getEntry();
                if (curSz != newSz || curEntry != newEntry) {
                    result.add(new SampleToChunkBox.SampleToChunkEntry(first, curSz, curEntry));
                    curSz = newSz;
                    curEntry = newEntry;
                    first += cnt;
                    cnt = 0;
                }
                ++cnt;
            }
            result.add(new SampleToChunkBox.SampleToChunkEntry(first, curSz, curEntry));
        }
        return SampleToChunkBox.createSampleToChunkBox(result.toArray(new SampleToChunkBox.SampleToChunkEntry[0]));
    }

    private static boolean intersects(long as, long ae, long bs, long be) {
        return as >= bs && as <= --be || --ae >= bs && ae <= be || bs >= as && bs <= ae || be >= as && be <= ae;
    }

    public void trim(MovieBox movie, String param) {
    }
}

