/*
 * Decompiled with CFR 0.152.
 */
package com.dkmk100.ars_industria;

import com.dkmk100.ars_industria.ArsIndustria;
import com.dkmk100.ars_industria.items.IESpellBulletItem;
import com.dkmk100.ars_industria.registry.IERegistry;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class ScribeBulletRecipe
extends CustomRecipe {
    public ScribeBulletRecipe(ResourceLocation name) {
        super(name);
        ArsIndustria.LOGGER.info("recipe constructor");
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        boolean hasBullet = false;
        boolean hasScroll = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (this.isSpellBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (stackInSlot.m_41720_() instanceof SpellParchment) {
                hasScroll = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasScroll;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        ItemStack bullet = ItemStack.f_41583_;
        Spell spell = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (bullet.m_41619_() && this.isSpellBullet(stackInSlot)) {
                bullet = stackInSlot;
                continue;
            }
            if (!(stackInSlot.m_41720_() instanceof SpellParchment)) continue;
            spell = ((SpellParchment)stackInSlot.m_41720_()).getSpellCaster(stackInSlot).getSpell();
        }
        if (!bullet.m_41619_()) {
            ItemStack newBullet = ItemHandlerHelper.copyStackWithSize((ItemStack)bullet, (int)1);
            if (newBullet.m_41720_() instanceof IESpellBulletItem) {
                IESpellBulletItem spellBulletItem = (IESpellBulletItem)newBullet.m_41720_();
                spellBulletItem.setSpell(spellBulletItem.getSpellCaster(newBullet), null, null, newBullet, spell);
            }
            return newBullet;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (!(item.m_41720_() instanceof SpellParchment)) continue;
            ItemStack stack = item.m_41777_();
            stack.m_41764_(1);
            nonnulllist.set(i, (Object)stack);
            nonnulllist.set(i, (Object)stack);
        }
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IERegistry.SCRIBE_BULLET.get();
    }

    private boolean isSpellBullet(ItemStack stack) {
        return stack.m_41720_() instanceof IESpellBulletItem;
    }
}

