/*
 * Decompiled with CFR 0.152.
 */
package com.dkmk100.ars_industria;

import com.dkmk100.ars_industria.registry.CompatHandler;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;

public class StatsModifier {
    List<AugmentModification> endModifications = new ArrayList<AugmentModification>();
    List<InnerAugmentModification> innerModifications = new ArrayList<InnerAugmentModification>();
    float costMultiplier = 1.0f;
    int costIncrease = 0;
    static Method getStats = null;
    static Method enoughMana = null;
    static Class AugmentError = null;

    public StatsModifier() {
    }

    public StatsModifier(float costMult) {
        this.costMultiplier = costMult;
    }

    public StatsModifier(float costMult, int costInc) {
        this.costMultiplier = costMult;
        this.costIncrease = costInc;
    }

    public StatsModifier withCost(float costMultiplier, int costIncrease) {
        this.costMultiplier = costMultiplier;
        this.costIncrease = costIncrease;
        return this;
    }

    public StatsModifier withAugment(AbstractAugment augment, int count, boolean hasCost) {
        this.endModifications.add(new AugmentModification(augment, hasCost, count));
        return this;
    }

    public StatsModifier withInnerAugment(AbstractAugment augment, int countEach, int maxTotal, boolean hasCost) {
        this.innerModifications.add(new InnerAugmentModification(augment, hasCost, countEach, maxTotal));
        return this;
    }

    public static boolean CastWithoutLimitErrors(SpellResolver resolver, HitResult result) {
        if (AugmentError == null) {
            StatsModifier.InitReflection();
        }
        try {
            SpellContext context = resolver.spellContext;
            LivingEntity caster = context.getUnwrappedCaster();
            ItemStack stack = context.getCasterTool();
            Spell spell = resolver.spell;
            ISpellValidator validator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
            List validationErrors = validator.validate(spell.recipe);
            for (SpellValidationError error : validationErrors) {
                if (AugmentError.isInstance(error)) continue;
                PortUtil.sendMessageNoSpam((Entity)caster, (Component)error.makeTextComponentExisting());
                return false;
            }
            if (!((Boolean)enoughMana.invoke((Object)resolver, caster)).booleanValue()) {
                return false;
            }
            resolver.onResolveEffect(caster.f_19853_, result);
            resolver.expendMana();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    static void InitReflection() {
        try {
            getStats = SpellResolver.class.getDeclaredMethod("getCastStats", new Class[0]);
            enoughMana = SpellResolver.class.getDeclaredMethod("enoughMana", LivingEntity.class);
            AugmentError = Class.forName("com.hollingsworth.arsnouveau.common.spell.validation.ActionAugmentationPolicyValidator$ActionAugmentationPolicyValidationError");
            getStats.setAccessible(true);
            enoughMana.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        Object str = "";
        str = (String)str + "cost mult: " + this.costMultiplier + "\n";
        str = (String)str + "cost addition " + this.costIncrease + "\n";
        for (AugmentModification augmentModification : this.endModifications) {
            str = (String)str + augmentModification.toString() + "\n";
        }
        for (InnerAugmentModification innerAugmentModification : this.innerModifications) {
            str = (String)str + innerAugmentModification.toString() + "\n";
        }
        return str;
    }

    public StatsModifier(StatsModifier mod) {
        for (AugmentModification augmentModification : mod.endModifications) {
            this.endModifications.add(new AugmentModification(augmentModification));
        }
        for (InnerAugmentModification innerAugmentModification : mod.innerModifications) {
            this.innerModifications.add(new InnerAugmentModification(innerAugmentModification));
        }
        this.costMultiplier = mod.costMultiplier;
        this.costIncrease = mod.costIncrease;
    }

    public void addTooltip(List<Component> tooltip) {
        for (AugmentModification augmentModification : this.endModifications) {
            if (augmentModification.affectCost) {
                tooltip.add((Component)Component.m_237113_((String)("Adds " + augmentModification.count + " " + augmentModification.augment.getLocaleName() + " to the end of the spell on cast, increasing cost accordingly")));
                continue;
            }
            tooltip.add((Component)Component.m_237113_((String)("Adds " + augmentModification.count + " free " + augmentModification.augment.getLocaleName() + " to the end of the spell on cast")));
        }
        for (InnerAugmentModification innerAugmentModification : this.innerModifications) {
            if (innerAugmentModification.affectCost) {
                tooltip.add((Component)Component.m_237113_((String)("Adds " + innerAugmentModification.countEach + " " + innerAugmentModification.augment.getLocaleName() + " to up to " + innerAugmentModification.totalEffects + " compatible effects on cast, increasing cost accordingly")));
                continue;
            }
            tooltip.add((Component)Component.m_237113_((String)("Adds " + innerAugmentModification.countEach + " free " + innerAugmentModification.augment.getLocaleName() + " to up to " + innerAugmentModification.totalEffects + " compatible effects on cast")));
        }
        float discount = (float)Math.round((1.0f - this.costMultiplier) * 1000.0f) / 10.0f;
        if (discount > 0.0f) {
            tooltip.add((Component)Component.m_237113_((String)("Spell discount: " + discount + "%")).m_130940_(ChatFormatting.DARK_GREEN));
        } else if (discount != 0.0f) {
            tooltip.add((Component)Component.m_237113_((String)("Spell cost increase: " + -1.0f * discount + "%")).m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.costIncrease > 0) {
            tooltip.add((Component)Component.m_237113_((String)("Spell flat cost increase: " + this.costIncrease + " mana")).m_130940_(ChatFormatting.DARK_RED));
        } else if (this.costIncrease < 0) {
            tooltip.add((Component)Component.m_237113_((String)("Spell flat discount: " + -1 * this.costIncrease + " mana")).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public StatsModifier Merge(StatsModifier other) {
        return this.Merge(other, true);
    }

    public StatsModifier Merge(StatsModifier other, boolean overrideSelf) {
        StatsModifier mod = this;
        if (!overrideSelf) {
            mod = new StatsModifier(this);
        }
        for (AugmentModification augmentModification : other.endModifications) {
            mod.endModifications.add(new AugmentModification(augmentModification));
        }
        for (InnerAugmentModification innerAugmentModification : other.innerModifications) {
            mod.innerModifications.add(new InnerAugmentModification(innerAugmentModification));
        }
        mod.costMultiplier *= other.costMultiplier;
        mod.costIncrease += other.costIncrease;
        return mod;
    }

    public Spell ModifySpell(Spell spell) {
        for (AugmentModification mod : this.endModifications) {
            spell.add((AbstractSpellPart)mod.augment, mod.count);
            if (mod.affectCost) continue;
            spell.addDiscount(mod.augment.getCastingCost());
        }
        int[] augsLeft = new int[this.innerModifications.size()];
        int i = 0;
        for (i = 0; i < this.innerModifications.size(); ++i) {
            augsLeft[i] = this.innerModifications.get((int)i).totalEffects;
        }
        ArrayList<Object> recipe = new ArrayList<Object>();
        i = 0;
        for (AbstractSpellPart part : spell.recipe) {
            recipe.add(part);
            for (int i4 = 0; i4 < this.innerModifications.size(); ++i4) {
                InnerAugmentModification augment = this.innerModifications.get(i4);
                if (!(part instanceof AbstractEffect) || !part.compatibleAugments.contains(augment.augment)) continue;
                boolean valid = true;
                if (CompatHandler.shouldIgnoreBuffs(part)) {
                    valid = false;
                } else if (i + 1 < spell.recipe.size()) {
                    AbstractSpellPart part2 = (AbstractSpellPart)spell.recipe.get(i + 1);
                    for (int i2 = i + 1; valid && i2 < spell.recipe.size() && part2 instanceof AbstractAugment; ++i2) {
                        part2 = (AbstractSpellPart)spell.recipe.get(i2);
                        if (part2 != AugmentDampen.INSTANCE) continue;
                        valid = false;
                    }
                }
                if (!valid || augsLeft[i4] <= 0) continue;
                int n = i4;
                augsLeft[n] = augsLeft[n] - 1;
                for (int i3 = 0; i3 < augment.countEach; ++i3) {
                    recipe.add(augment.augment);
                    if (augment.affectCost) continue;
                    spell.addDiscount(augment.augment.getCastingCost());
                }
            }
            ++i;
        }
        spell.recipe = recipe;
        spell.addDiscount(Math.round((float)spell.getDiscountedCost() * (1.0f - this.costMultiplier)));
        return spell;
    }

    static class AugmentModification {
        AbstractAugment augment;
        boolean affectCost;
        int count;

        public String toString() {
            return "AugmentModification{augment=" + this.augment + ", affectCost=" + this.affectCost + ", count=" + this.count + "}";
        }

        public AugmentModification(AbstractAugment aug, boolean costs, int amount) {
            this.augment = aug;
            this.affectCost = costs;
            this.count = amount;
        }

        public AugmentModification(AugmentModification mod) {
            this.augment = mod.augment;
            this.affectCost = mod.affectCost;
            this.count = mod.count;
        }
    }

    static class InnerAugmentModification {
        AbstractAugment augment;
        boolean affectCost;
        int countEach;
        int totalEffects;

        public String toString() {
            return "InnerAugmentModification{augment=" + this.augment + ", affectCost=" + this.affectCost + ", countEach=" + this.countEach + ", totalEffects=" + this.totalEffects + "}";
        }

        public InnerAugmentModification(AbstractAugment aug, boolean costs, int amountEach, int amountTotal) {
            this.augment = aug;
            this.affectCost = costs;
            this.countEach = amountEach;
            this.totalEffects = amountTotal;
        }

        public InnerAugmentModification(InnerAugmentModification mod) {
            this.augment = mod.augment;
            this.affectCost = mod.affectCost;
            this.countEach = mod.countEach;
            this.totalEffects = mod.totalEffects;
        }
    }
}

