/*
 * Decompiled with CFR 0.152.
 */
package com.dkmk100.ars_industria.blocks;

import com.dkmk100.ars_industria.registry.BotaniaRegistry;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.common.helper.MathHelper;

public class ManaRelay
extends ModdedTile
implements ITickable,
WandBindable {
    BlockPos bindingPos = null;

    public ManaRelay(BlockPos pos, BlockState state) {
        this((BlockEntityType)BotaniaRegistry.manaRelay.get(), pos, state);
    }

    public ManaRelay(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        this.transferMana();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.bindingPos != null) {
            NBTUtil.storeBlockPos((CompoundTag)tag, (String)"bound", (BlockPos)this.bindingPos);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (NBTUtil.hasBlockPos((CompoundTag)tag, (String)"bound")) {
            this.bindingPos = NBTUtil.getBlockPos((CompoundTag)tag, (String)"bound");
        }
    }

    @Nullable
    SourceJarTile getJar(int range, Level world, int minSource) {
        Optional loc = BlockPos.m_121930_((BlockPos)this.m_58899_(), (int)range, (int)range, b -> world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).getSource() >= minSource);
        if (!loc.isPresent()) {
            return null;
        }
        SourceJarTile tile = (SourceJarTile)world.m_7702_((BlockPos)loc.get());
        return tile;
    }

    void MakeTakeParticles(BlockPos result) {
        EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(this.f_58857_, result, this.f_58858_);
        this.f_58857_.m_7967_((Entity)aoeProjectile);
    }

    public void transferMana() {
        ManaCollector collector = this.findBindCandidateAt(this.bindingPos);
        if (collector != null && this.f_58857_.m_46467_() % 20L == 0L && !collector.isFull()) {
            SourceJarTile tile = this.getJar(5, this.m_58904_(), 100);
            if (tile == null) {
                return;
            }
            float rawManaAvailable = tile.getSource() * BotaniaRegistry.getManaPerSource();
            float rawMana = Math.min(rawManaAvailable, (float)(collector.getMaxMana() - collector.getCurrentMana()));
            int sourceTaken = Math.round(rawMana / (float)BotaniaRegistry.getManaPerSource());
            int manaTransfered = (int)Math.round((double)rawMana * BotaniaRegistry.getEfficiency());
            tile.addSource(-1 * sourceTaken);
            collector.receiveMana(manaTransfered);
            this.MakeTakeParticles(tile.m_58899_());
            this.updateBlock();
        }
    }

    public boolean canSelect(Player player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        if (this.wouldBeValidBinding(pos)) {
            this.setBindingPos(pos);
            return true;
        }
        return false;
    }

    public void setBindingPos(@javax.annotation.Nullable BlockPos bindingPos) {
        boolean changed = !Objects.equals(this.bindingPos, bindingPos);
        this.bindingPos = bindingPos;
        if (changed) {
            this.updateBlock();
        }
    }

    public boolean wouldBeValidBinding(@javax.annotation.Nullable BlockPos pos) {
        if (this.f_58857_ == null || pos == null || !this.f_58857_.m_46749_(pos) || MathHelper.distSqr((Vec3i)this.m_58899_(), (Vec3i)pos) > (long)this.getBindingRadius() * (long)this.getBindingRadius()) {
            return false;
        }
        return this.findBindCandidateAt(pos) != null;
    }

    public int getBindingRadius() {
        return 6;
    }

    @javax.annotation.Nullable
    public ManaCollector findBindCandidateAt(BlockPos pos) {
        if (this.f_58857_ == null || pos == null) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        return be != null && ManaCollector.class.isAssignableFrom(be.getClass()) ? (ManaCollector)be : null;
    }

    @Nullable
    public BlockPos getBinding() {
        return this.bindingPos;
    }
}

