/*
 * Decompiled with CFR 0.152.
 */
package com.dkmk100.ars_industria.items;

import com.dkmk100.ars_industria.StatsModifier;
import com.dkmk100.ars_industria.entities.ISpellBullet;
import com.dkmk100.ars_industria.items.SourceBullet;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import lykrast.gunswithoutroses.entity.BulletEntity;
import lykrast.gunswithoutroses.item.IBullet;
import lykrast.gunswithoutroses.item.ShotgunItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EnchantersShotgun
extends ShotgunItem
implements ICasterTool,
ISpellModifierItem {
    private int bulletCount;
    StatsModifier statsModifier;
    boolean creativeOnly = false;

    public EnchantersShotgun(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, int bullets, float spellCostMultiplier) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability, bullets);
        this.bulletCount = bullets;
        this.statsModifier = new StatsModifier(spellCostMultiplier);
    }

    public EnchantersShotgun(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, int bullets, StatsModifier statsModifier) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability, bullets);
        this.bulletCount = bullets;
        this.statsModifier = new StatsModifier(statsModifier);
    }

    public EnchantersShotgun setCreative() {
        this.creativeOnly = true;
        return this;
    }

    protected void shoot(Level world, Player player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        for (int i = 0; i < this.bulletCount; ++i) {
            this.doShoot(world, player, gun, ammo, bulletItem, bulletFree);
        }
    }

    protected void doShoot(Level world, Player player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        BulletEntity shot = bulletItem.createProjectile(world, ammo, (LivingEntity)player);
        shot.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)this.getProjectileSpeed(gun, player), (float)this.getInaccuracy(gun, player));
        shot.setDamage((shot.getDamage() + this.getBonusDamage(gun, player)) * this.getDamageMultiplier(gun, player));
        shot.setIgnoreInvulnerability(this.ignoreInvulnerability);
        this.changeBullet(world, player, gun, shot, bulletFree);
        world.m_7967_((Entity)shot);
        Spell spell = this.getSpellCaster(gun).getSpell();
        if (spell != null && spell.recipe.size() > 0) {
            StatsModifier tempModifier = new StatsModifier(this.statsModifier);
            if (bulletItem instanceof SourceBullet) {
                ((SourceBullet)bulletItem).MergeStats(tempModifier);
            }
            spell = tempModifier.ModifySpell(spell);
            ISpellBullet spellBullet = (ISpellBullet)shot;
            spellBullet.setSpell(spell);
        }
    }

    public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return super.setSpell(caster, player, hand, stack, spell);
    }

    public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.sword.invalid"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.creativeOnly) {
            tooltip.add((Component)Component.m_237113_((String)"Creative mode only item").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (this.repairMaterial != null && this.repairMaterial.get() != null && ((Ingredient)this.repairMaterial.get()).m_43908_().length > 0) {
            tooltip.add((Component)Component.m_237113_((String)("Repair with " + ((Ingredient)this.repairMaterial.get()).m_43908_()[0].m_41611_().getString())));
        }
        this.getInformation(stack, worldIn, tooltip, flagIn);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237113_((String)"Note: spell will NOT ignore i-frames, only the actual bullet damage will").m_130940_(ChatFormatting.RED));
    }

    protected void addExtraStatsTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip) {
        super.addExtraStatsTooltip(stack, world, tooltip);
        this.statsModifier.addTooltip(tooltip);
    }
}

