/*
 * Decompiled with CFR 0.152.
 */
package com.dkmk100.ars_industria.items;

import com.dkmk100.ars_industria.ArsIndustria;
import com.dkmk100.ars_industria.StatsModifier;
import com.dkmk100.ars_industria.entities.ISpellBullet;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import java.util.List;
import lykrast.gunswithoutroses.entity.BulletEntity;
import lykrast.gunswithoutroses.item.BulletItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SourceBullet
extends BulletItem {
    private boolean creativeItem;
    private StatsModifier statsModifier;

    public SourceBullet(Item.Properties pProperties, int damage) {
        super(pProperties, damage);
    }

    public SourceBullet(Item.Properties pProperties, int damage, float costMultiplier) {
        super(pProperties, damage);
        this.statsModifier = new StatsModifier(costMultiplier);
    }

    public SourceBullet setCreative() {
        this.creativeItem = true;
        return this;
    }

    public void MergeStats(StatsModifier other) {
        other.Merge(this.statsModifier);
    }

    public SourceBullet(Item.Properties pProperties, int damage, float costMultiplier, AbstractAugment augment, int augmentCount) {
        super(pProperties, damage);
        this.statsModifier = new StatsModifier(costMultiplier).withAugment(augment, augmentCount, false);
    }

    public StatsModifier getModifier() {
        return this.statsModifier;
    }

    public static void castOnEntity(BulletEntity projectile, LivingEntity target, @Nullable Entity shooter, Level world) {
        if (!world.f_46443_ && shooter instanceof Player) {
            ISpellBullet spellBullet = (ISpellBullet)projectile;
            Spell spell = spellBullet.getSpell();
            Player player = (Player)shooter;
            ArsIndustria.LOGGER.info("trying to cast spell on entity");
            SpellContext context = new SpellContext(world, spell, (LivingEntity)((Player)shooter), (IWrappedCaster)new PlayerCaster((Player)shooter));
            SpellResolver resolver = new SpellResolver(context);
            StatsModifier.CastWithoutLimitErrors(resolver, (HitResult)new EntityHitResult((Entity)target));
        }
    }

    public static void castOnBlock(BulletEntity projectile, BlockHitResult result, @Nullable Entity shooter, Level world) {
        if (!world.f_46443_ && shooter instanceof Player) {
            ISpellBullet spellBullet = (ISpellBullet)projectile;
            Spell spell = spellBullet.getSpell();
            Player player = (Player)shooter;
            SpellContext context = new SpellContext(world, spell, (LivingEntity)((Player)shooter), (IWrappedCaster)new PlayerCaster((Player)shooter));
            SpellResolver resolver = new SpellResolver(context);
            StatsModifier.CastWithoutLimitErrors(resolver, (HitResult)result);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.creativeItem) {
            tooltip.add((Component)Component.m_237113_((String)"Creative mode only item").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.statsModifier.addTooltip(tooltip);
    }
}

