/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.client.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.config.ClientConfig;
import fuzs.blockrunner.data.BlockSpeedManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.ArrayUtils;

public class FieldOfViewHelper {
    public static boolean shouldRemoveBlockSpeedModifier(Player player) {
        if (!((ClientConfig)BlockRunner.CONFIG.get(ClientConfig.class)).disableFieldOfViewChanges) {
            return false;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && player.m_150108_()) {
            return false;
        }
        return player.m_21204_().m_22154_(Attributes.f_22279_, BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
    }

    public static float getFieldOfViewModifierWithoutBlockSpeed(Player player) {
        float fovModifier = player.m_150110_().f_35935_ ? 1.1f : 1.0f;
        double movementSpeed = FieldOfViewHelper.calculateAttributeValueSkipping(player.m_21051_(Attributes.f_22279_), BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
        return fovModifier *= ((float)movementSpeed / player.m_150110_().m_35947_() + 1.0f) / 2.0f;
    }

    private static double calculateAttributeValueSkipping(AttributeInstance attributeInstance, UUID ... skippedModifierIds) {
        double baseValue = attributeInstance.m_22115_();
        Map operationToModifiers = Stream.of(AttributeModifier.Operation.values()).collect(Collectors.toMap(Function.identity(), operation -> Sets.newHashSet(), (o1, o2) -> o1, () -> Maps.newEnumMap(AttributeModifier.Operation.class)));
        attributeInstance.m_22122_().stream().filter(modifier -> !ArrayUtils.contains((Object[])skippedModifierIds, (Object)modifier.m_22209_())).forEach(modifier -> ((Set)operationToModifiers.get(modifier.m_22217_())).add(modifier));
        for (AttributeModifier attributeModifier : (Set)operationToModifiers.get(AttributeModifier.Operation.ADDITION)) {
            baseValue += attributeModifier.m_22218_();
        }
        double baseValueCopy = baseValue;
        for (AttributeModifier attributeModifier : (Set)operationToModifiers.get(AttributeModifier.Operation.MULTIPLY_BASE)) {
            baseValueCopy += baseValue * attributeModifier.m_22218_();
        }
        for (AttributeModifier attributeModifier : (Set)operationToModifiers.get(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            baseValueCopy *= 1.0 + attributeModifier.m_22218_();
        }
        return attributeInstance.m_22099_().m_6740_(baseValueCopy);
    }
}

