/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.items;

import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.util.Platform;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemMEPackingTape
extends Item {
    private static final ObjectSet<ResourceLocation> WHITE_LIST = new ObjectOpenHashSet();

    public ItemMEPackingTape() {
        super(new Item.Properties().m_41503_(64).m_41491_(EPPItemAndBlock.TAB));
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Direction side = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            CompoundTag tag = new CompoundTag();
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                IPart part = cable.getPart(side);
                if (part != null) {
                    tag.m_128379_("part", true);
                    Item partItem = part.getPartItem().m_5456_();
                    ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)partItem);
                    if (!WHITE_LIST.contains((Object)id)) {
                        return InteractionResult.PASS;
                    }
                    assert (id != null);
                    tag.m_128359_("id", id.toString());
                    CompoundTag ctxTag = new CompoundTag();
                    part.writeToNBT(ctxTag);
                    ctxTag.m_128379_("exae_reload", true);
                    tag.m_128365_("ctx", (Tag)ctxTag);
                    cable.removePart(part);
                }
            } else {
                tag.m_128379_("part", false);
                BlockState state = tile.m_58900_();
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                if (!WHITE_LIST.contains((Object)blockId)) {
                    return InteractionResult.PASS;
                }
                ResourceLocation id = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_());
                assert (id != null);
                assert (blockId != null);
                tag.m_128359_("id", id.toString());
                tag.m_128359_("block_id", blockId.toString());
                tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
                CompoundTag ctxTag = tile.serializeNBT();
                tag.m_128365_("ctx", (Tag)ctxTag);
                world.m_46747_(pos);
                world.m_7471_(pos, false);
            }
            if (!tag.m_128456_()) {
                ItemStack pack = new ItemStack((ItemLike)EPPItemAndBlock.PACKAGE);
                pack.m_41751_(tag);
                Platform.spawnDrops((Level)world, (BlockPos)pos, Collections.singletonList(pack));
                context.m_43722_().m_220157_(1, RandomSource.m_216327_(), null);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack is, Level world, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        lines.add((Component)Component.m_237115_((String)"me_packing_tape.tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public static void registerPackableDevice(ResourceLocation id) {
        WHITE_LIST.add((Object)id);
    }
}

