/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.container;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.SetStockAmountMenu;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigMenuInventory;
import com.github.glodblock.epp.client.ExSemantics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class ContainerExInterface
extends UpgradeableMenu<InterfaceLogicHost> {
    public static final String ACTION_OPEN_SET_AMOUNT = "setAmount";
    public static final MenuType<ContainerExInterface> TYPE = MenuTypeBuilder.create(ContainerExInterface::new, InterfaceLogicHost.class).build("ex_interface");

    public ContainerExInterface(int id, Inventory ip, InterfaceLogicHost host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(ACTION_OPEN_SET_AMOUNT, Integer.class, this::openSetAmountMenu);
        InterfaceLogic logic = host.getInterfaceLogic();
        ConfigMenuInventory config = logic.getConfig().createMenuWrapper();
        for (int x = 0; x < config.size(); ++x) {
            this.addSlot((Slot)new FakeSlot((InternalInventory)config, x), x < 9 ? ExSemantics.EX_1 : ExSemantics.EX_3);
        }
        ConfigMenuInventory storage = logic.getStorage().createMenuWrapper();
        for (int x = 0; x < storage.size(); ++x) {
            this.addSlot((Slot)new AppEngSlot((InternalInventory)storage, x), x < 9 ? ExSemantics.EX_2 : ExSemantics.EX_4);
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
    }

    public void openSetAmountMenu(int configSlot) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_OPEN_SET_AMOUNT, configSlot);
        } else {
            GenericStack stack = ((InterfaceLogicHost)this.getHost()).getConfig().getStack(configSlot);
            if (stack != null) {
                SetStockAmountMenu.open((ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuLocator)this.getLocator(), (int)configSlot, (AEKey)stack.what(), (int)((int)stack.amount()));
            }
        }
    }
}

