/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.datagen;

import appeng.datagen.providers.IAE2DataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class EPPLootTableProvider
extends BlockLoot
implements IAE2DataProvider {
    private final Map<Block, Function<Block, LootTable.Builder>> overrides = ImmutableMap.of();
    private final Path outputFolder;

    public EPPLootTableProvider(Path outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (Map.Entry entry : Registry.f_122824_.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("expatternprovider")) continue;
            LootTable.Builder builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((Block)entry.getValue());
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, ((ResourceKey)entry.getKey()).m_135782_()));
        }
    }

    private LootTable.Builder defaultBuilder(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootTables.m_79200_((LootTable)this.finishBuilding(builder));
    }

    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.m_79165_(LootContextParamSets.f_81421_).m_79167_();
    }

    @NotNull
    public String m_6055_() {
        return "ExtendedAE Block Drops";
    }
}

