/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import com.communi.suggestu.scena.core.blockstate.ILevelBasedPropertyAccessor;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.fluid.IFluidManager;
import java.util.Optional;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.BitStorageBlock;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BitStorageBlockEntity
extends BlockEntity
implements Container {
    private IBlockInformation state = null;
    private int bits = 0;
    private int oldLV = -1;

    public BitStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BIT_STORAGE.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag tag = nbt.m_128469_("block_information");
        this.state = new BlockInformation(tag);
        this.bits = nbt.m_128451_("bits");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.state != null) {
            compound.m_128365_("block_information", this.state.serializeNBT());
            compound.m_128405_("bits", this.bits);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public boolean addAllPossibleBits(Player playerIn) {
        if (playerIn != null && playerIn.m_6144_() && this.state != null && !this.state.isAir()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(playerIn);
            int extractionAmount = Math.min(StateEntrySize.current().getBitsPerBlock() - this.bits, bitInventory.getMaxExtractAmount(this.state));
            bitInventory.extract(this.state, extractionAmount);
            this.bits += extractionAmount;
            this.saveAndUpdate();
        }
        return false;
    }

    private void saveAndUpdate() {
        if (this.f_58857_ == null || this.m_58904_() == null) {
            return;
        }
        if (this.bits == 0) {
            this.state = null;
        }
        if (this.state == null) {
            this.bits = 0;
        }
        this.m_6596_();
        this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 0);
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.m_58904_().m_5518_().m_7174_(this.m_58899_());
            this.oldLV = lv;
        }
    }

    public int getLightValue() {
        return ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(this.state == null ? BlockInformation.AIR : this.state, this.m_58899_(), (LevelReader)this.m_58904_()), this.m_58899_());
    }

    public boolean addHeldBits(ItemStack current, Player playerIn) {
        if (current.m_41619_()) {
            return false;
        }
        if (playerIn.m_6144_() || this.bits == 0) {
            Optional containedFluid;
            IBlockInformation stackState;
            Item item = current.m_41720_();
            if (item instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)item;
                if (bitItem.getBlockInformation(current) == this.state || this.state == null) {
                    this.state = bitItem.getBlockInformation(current);
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = Math.min(maxToInsert, current.m_41613_());
                    this.bits += toInsert;
                    if (!playerIn.m_7500_()) {
                        current.m_41774_(toInsert);
                        playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, current);
                        playerIn.m_150109_().m_6596_();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            } else if (IEligibilityManager.getInstance().canBeChiseled(current) && (stackState = ItemStackUtils.getStateFromItem(current)).getBlockState().m_60734_() != Blocks.f_50016_ && (this.state == null || this.state.isAir())) {
                this.state = stackState;
                this.bits = StateEntrySize.current().getBitsPerBlock();
                if (!playerIn.m_7500_()) {
                    current.m_41774_(1);
                    playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, current);
                    playerIn.m_150109_().m_6596_();
                }
                this.saveAndUpdate();
                return true;
            }
            if ((containedFluid = IFluidManager.getInstance().get(current)).isPresent() && ((FluidInformation)containedFluid.get()).amount() > 0L) {
                BlockState state = ((FluidInformation)containedFluid.get()).fluid().m_76145_().m_76188_();
                BlockInformation blockInformation = new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant((FluidInformation)containedFluid.get()));
                if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) && (this.state == null || blockInformation.isAir())) {
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = (int)Math.min((float)maxToInsert, this.getBitCountFrom((FluidInformation)containedFluid.get()));
                    this.state = blockInformation;
                    this.bits += toInsert;
                    if (!playerIn.m_7500_()) {
                        ItemStack resultStack = IFluidManager.getInstance().extractFrom(current, (long)toInsert);
                        playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, resultStack);
                        playerIn.m_150109_().m_6596_();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            }
        }
        return false;
    }

    private float getBitCountFrom(FluidInformation containedFluid) {
        return (float)StateEntrySize.current().getBitsPerBlock() * ((float)containedFluid.amount() / (float)IFluidManager.getInstance().getBucketAmount());
    }

    public boolean extractBits(Player playerIn) {
        if (!playerIn.m_6144_()) {
            Item item;
            ItemStack is = this.m_8020_(0);
            if (!is.m_41619_() && (item = is.m_41720_()) instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)item;
                IBlockInformation blockState = bitItem.getBlockInformation(is);
                BitInventoryUtils.insertIntoOrSpawn(playerIn, blockState, is.m_41613_());
                this.m_7407_(0, is.m_41613_());
            }
            return true;
        }
        return false;
    }

    public IBlockInformation getContainedBlockInformation() {
        return this.state;
    }

    public int getBits() {
        return this.bits;
    }

    public Direction getFacing() {
        return (Direction)this.m_58904_().m_8055_(this.m_58899_()).m_61143_(BitStorageBlock.FACING);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.state == null || this.bits == 0;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index != 0) {
            return ItemStack.f_41583_;
        }
        if (this.state == null) {
            return ItemStack.f_41583_;
        }
        return IBitItemManager.getInstance().create(this.state, Math.min(64, this.bits));
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        if (index != 0) {
            return ItemStack.f_41583_;
        }
        IBlockInformation currentState = this.state;
        int toRemove = Math.min(count, this.bits);
        this.bits -= toRemove;
        this.saveAndUpdate();
        return IBitItemManager.getInstance().create(currentState, toRemove);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, @NotNull ItemStack itemStack) {
        if (index != 0 || !(itemStack.m_41720_() instanceof IBitItem) || ((IBitItem)itemStack.m_41720_()).getBlockInformation(itemStack) == this.state) {
            return;
        }
        this.saveAndUpdate();
        this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), this.bits + itemStack.m_41613_());
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.state = null;
        this.bits = 0;
        this.saveAndUpdate();
    }

    public Optional<FluidInformation> getFluid() {
        if (!this.containsFluid()) {
            return Optional.empty();
        }
        long amount = (long)((float)this.bits / ((float)StateEntrySize.current().getBitsPerBlock() / (float)IFluidManager.getInstance().getBucketAmount()));
        Optional<FluidInformation> dynamicFluid = IStateVariantManager.getInstance().getFluidInformation(this.state, amount);
        if (dynamicFluid.isPresent()) {
            return dynamicFluid;
        }
        return Optional.of(new FluidInformation(((LiquidBlock)this.state.getBlockState().m_60734_()).m_5888_(this.state.getBlockState()).m_76152_(), amount, new CompoundTag()));
    }

    public boolean containsFluid() {
        LiquidBlock liquidBlock;
        if (this.state == null) {
            return false;
        }
        long amount = (long)((float)this.bits / ((float)StateEntrySize.current().getBitsPerBlock() / (float)IFluidManager.getInstance().getBucketAmount()));
        Optional<FluidInformation> dynamicFluid = IStateVariantManager.getInstance().getFluidInformation(this.state, amount);
        if (dynamicFluid.isPresent()) {
            return true;
        }
        Block block = this.state.getBlockState().m_60734_();
        return block instanceof LiquidBlock && !(liquidBlock = (LiquidBlock)block).m_5888_(this.state.getBlockState()).m_76178_();
    }

    public void extractBits(int count) {
        this.bits = Math.max(0, this.bits - count);
        if (this.bits <= 0) {
            this.state = null;
        }
        this.saveAndUpdate();
    }

    public void insertBits(int bitCountToInsert, IBlockInformation blockInformation) {
        if (this.state == null || blockInformation.equals(this.state)) {
            this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), bitCountToInsert + this.bits);
            this.state = blockInformation;
            this.saveAndUpdate();
        }
    }

    public void insertBitsFromFluid(FluidInformation fluidInformation) {
        BlockInformation fluidBlockInformation = new BlockInformation(fluidInformation.fluid().m_76145_().m_76188_(), IStateVariantManager.getInstance().getStateVariant(fluidInformation));
        if (this.state == null || this.state.equals(fluidBlockInformation)) {
            this.bits = (int)Math.max((float)StateEntrySize.current().getBitsPerBlock(), this.getBitCountFrom(fluidInformation) + (float)this.bits);
            this.state = fluidBlockInformation;
            this.saveAndUpdate();
        }
    }

    public void setContents(BlockInformation blockInformation, int count) {
        this.state = blockInformation;
        this.bits = count;
        this.saveAndUpdate();
    }
}

