/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.config;

import com.lgmrszd.compressedcreativity.CompressedCreativity;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import me.desht.pneumaticcraft.api.pressure.PressureTier;

public class PressureTierConfig {

    public static enum PressureTierEnum {
        TIER_ONE(PressureTier.TIER_ONE),
        TIER_ONE_HALF(PressureTier.TIER_ONE_HALF),
        TIER_TWO(PressureTier.TIER_TWO),
        CUSTOM;

        private final PressureTier pressureTier;

        private PressureTierEnum(PressureTier pressureTier) {
            this.pressureTier = pressureTier;
        }

        private PressureTierEnum() {
            this.pressureTier = PressureTier.TIER_ONE;
        }

        public PressureTier getPressureTier() {
            return this.pressureTier;
        }
    }

    public static enum CustomTier implements PressureTier
    {
        ROTATIONAL_COMPRESSOR_TIER("rotational_compressor"),
        AIR_BLOWER_TIER("air_blower"),
        INDUSTRIAL_AIR_BLOWER_TIER("industrial_air_blower"),
        COMPRESSED_AIR_ENGINE_TIER("compressed_air_engine");

        private final String key;

        private CustomTier(String key) {
            this.key = key;
        }

        public float getDangerPressure() {
            if (!CommonConfig.MACHINE_PRESSURE_TIERS.containsKey(this.key)) {
                return this.fallbackTier(false);
            }
            if (CommonConfig.MACHINE_PRESSURE_TIERS.get(this.key).get() != PressureTierEnum.CUSTOM) {
                return ((PressureTierEnum)((Object)CommonConfig.MACHINE_PRESSURE_TIERS.get(this.key).get())).getPressureTier().getDangerPressure();
            }
            if (!CommonConfig.CUSTOM_DANGER_PRESSURE.containsKey(this.key)) {
                return this.fallbackPressure(false);
            }
            return ((Double)CommonConfig.CUSTOM_DANGER_PRESSURE.get(this.key).get()).floatValue();
        }

        public float getCriticalPressure() {
            if (!CommonConfig.MACHINE_PRESSURE_TIERS.containsKey(this.key)) {
                return this.fallbackTier(true);
            }
            if (CommonConfig.MACHINE_PRESSURE_TIERS.get(this.key).get() != PressureTierEnum.CUSTOM) {
                return ((PressureTierEnum)((Object)CommonConfig.MACHINE_PRESSURE_TIERS.get(this.key).get())).getPressureTier().getCriticalPressure();
            }
            if (!CommonConfig.CUSTOM_CRITICAL_PRESSURE.containsKey(this.key)) {
                return this.fallbackPressure(true);
            }
            return ((Double)CommonConfig.CUSTOM_CRITICAL_PRESSURE.get(this.key).get()).floatValue();
        }

        private float fallbackTier(boolean critical) {
            CompressedCreativity.LOGGER.error("Config entry of pressure tier for {} is missing", (Object)this.key);
            return critical ? 7.0f : 5.0f;
        }

        private float fallbackPressure(boolean critical) {
            CompressedCreativity.LOGGER.error("Config entry of custom {} pressure for {} is missing", (Object)(critical ? "critical" : "danger"), (Object)this.key);
            return critical ? 7.0f : 5.0f;
        }

        public String getKey() {
            return this.key;
        }
    }
}

