/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.index;

import com.lgmrszd.compressedcreativity.blocks.bracketed_pressure_tube.BracketedPressureTubeBlock;
import com.lgmrszd.compressedcreativity.index.CCBlocks;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IMiscHelpers;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class CCModsReference {
    public static ParticleOptions getAirParticle() {
        IMiscHelpers miscHelpers = PneumaticRegistry.getInstance().getMiscHelpers();
        return miscHelpers.airParticle();
    }

    public static Block getPlasticBrickBlockByColor(DyeColor color) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pneumaticcraft", "plastic_brick_" + color.m_41065_()));
    }

    public static enum BracketedPressureTube {
        BASIC(0, (BracketedPressureTubeBlock)((Object)CCBlocks.BRACKETED_PRESSURE_TUBE.get())),
        REINFORCED(1, (BracketedPressureTubeBlock)((Object)CCBlocks.BRACKETED_REINFORCED_PRESSURE_TUBE.get())),
        ADVANCED(2, (BracketedPressureTubeBlock)((Object)CCBlocks.BRACKETED_ADVANCED_PRESSURE_TUBE.get()));

        private final int tier;
        private final BracketedPressureTubeBlock block;

        private BracketedPressureTube(int tier, BracketedPressureTubeBlock block) {
            this.tier = tier;
            this.block = block;
        }

        public int getTier() {
            return this.tier;
        }

        public BracketedPressureTubeBlock getBlock() {
            return this.block;
        }

        public static BracketedPressureTube getByTier(int tier) {
            return switch (tier) {
                case 1 -> REINFORCED;
                case 2 -> ADVANCED;
                default -> BASIC;
            };
        }

        public static BracketedPressureTube getByBlock(Block block) {
            if (!(block instanceof BracketedPressureTubeBlock)) {
                return null;
            }
            BracketedPressureTubeBlock tubeBlock = (BracketedPressureTubeBlock)block;
            if (tubeBlock == BracketedPressureTube.BASIC.block) {
                return BASIC;
            }
            if (tubeBlock == BracketedPressureTube.REINFORCED.block) {
                return REINFORCED;
            }
            if (tubeBlock == BracketedPressureTube.ADVANCED.block) {
                return ADVANCED;
            }
            return null;
        }
    }

    public static enum PNCPressureTube {
        BASIC(0, "pressure_tube"),
        REINFORCED(1, "reinforced_pressure_tube"),
        ADVANCED(2, "advanced_pressure_tube");

        private final int tier;
        private final String id;
        private final Block block;

        private PNCPressureTube(int tier, String id) {
            this.tier = tier;
            this.id = id;
            this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pneumaticcraft", id));
        }

        public int getTier() {
            return this.tier;
        }

        public String getId() {
            return this.id;
        }

        public Block getBlock() {
            return this.block;
        }

        public static PNCPressureTube getByTier(int tier) {
            return switch (tier) {
                case 1 -> REINFORCED;
                case 2 -> ADVANCED;
                default -> BASIC;
            };
        }

        public static Block getBlockByTier(int tier) {
            return PNCPressureTube.getByTier(tier).getBlock();
        }

        public static PNCPressureTube getByBlock(Block block) {
            ResourceLocation loc = Registry.f_122824_.m_7981_((Object)block);
            if (!loc.m_135827_().equals("pneumaticcraft")) {
                return null;
            }
            String path = loc.m_135815_();
            if (path.equals(PNCPressureTube.BASIC.id)) {
                return BASIC;
            }
            if (path.equals(PNCPressureTube.ADVANCED.id)) {
                return ADVANCED;
            }
            if (path.equals(PNCPressureTube.REINFORCED.id)) {
                return REINFORCED;
            }
            return null;
        }
    }
}

