/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.network;

import com.lgmrszd.compressedcreativity.network.CCNetwork;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ObservePacket {
    private BlockPos pos;
    private int node;
    private static int cooldown = 0;

    public ObservePacket(BlockPos pos, int node) {
        this.pos = pos;
        this.node = node;
    }

    public static void encode(ObservePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.node);
    }

    public static ObservePacket decode(FriendlyByteBuf buf) {
        return new ObservePacket(buf.m_130135_(), buf.readInt());
    }

    public static void handle(ObservePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    ObservePacket.sendUpdate(pkt, player);
                }
            }
            catch (Exception var3) {
                var3.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(ObservePacket pkt, ServerPlayer player) {
        BlockEntity te = player.f_19853_.m_7702_(pkt.pos);
        if (te instanceof IObserveTileEntity) {
            ((IObserveTileEntity)te).onObserved(player, pkt);
            Packet supdatetileentitypacket = te.m_58483_();
            if (supdatetileentitypacket != null) {
                player.f_8906_.m_9829_(supdatetileentitypacket);
            }
        }
    }

    public static void tick() {
        if (--cooldown < 0) {
            cooldown = 0;
        }
    }

    public static void send(BlockPos pos, int node) {
        if (cooldown <= 0) {
            cooldown = 10;
            CCNetwork.NETWORK.sendToServer((Object)new ObservePacket(pos, node));
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getNode() {
        return this.node;
    }
}

