/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Task.class})
public abstract class MixinTask
extends QuestObject {
    boolean secret;

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        if (this.secret) {
            nbt.m_128379_("secret", this.secret);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.secret = nbt.m_128471_("secret");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.secret);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.secret = buffer.readBoolean();
    }

    public boolean isVisible(TeamData team) {
        Task quest;
        if (this.secret && !team.isCompleted((QuestObject)(quest = this.This()))) {
            return false;
        }
        return super.isVisible(team);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("is_secret", this.secret, v -> {
            this.secret = v;
        }, false).setNameKey("questsadditions.is_secret");
    }

    private Task This() {
        return (Task)this;
    }
}

