/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.itr;

import java.util.Iterator;
import java.util.function.Predicate;

public class FilterIterator<T>
implements Iterator<T> {
    private final Predicate predicate;
    private final Iterator itr;
    private T next;

    public FilterIterator(Iterable iterable, Class clazz) {
        this(iterable.iterator(), clazz);
    }

    public FilterIterator(Iterator iterable, Class clazz) {
        this(iterable, (E x) -> clazz.isInstance(x));
    }

    public <E> FilterIterator(Iterable<E> iterable, Predicate<E> predicate) {
        this(iterable.iterator(), predicate);
    }

    public <E> FilterIterator(Iterator<E> iterator, Predicate<E> predicate) {
        this.itr = iterator;
        this.predicate = predicate;
        this.findNext();
    }

    private void findNext() {
        while (this.next == null && this.itr.hasNext()) {
            Object object = this.itr.next();
            if (!this.predicate.test(object)) continue;
            this.next = object;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T result = this.next;
        this.next = null;
        this.findNext();
        return result;
    }
}

