/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.addons.crt;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.entity.CTEntityIngredient;
import com.blamejared.crafttweaker.api.event.CTEventManager;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.addons.crt.util.DimensionCondition;
import net.darkhax.gamestages.addons.crt.util.DimensionHook;
import net.darkhax.gamestages.addons.crt.util.FishingCondition;
import net.darkhax.gamestages.addons.crt.util.FishingHook;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.gamestages.StageHelper")
public class StageHelper {
    @ZenCodeType.Method
    public static void grantStageOnKill(CTEntityIngredient condition, String ... stages) {
        StageHelper.grantStageOnKill(condition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnKill(CTEntityIngredient condition, @Nullable BiConsumer<Player, LivingEntity> hook, String ... stages) {
        StageHelper.grantStageOnKill((Player p, LivingEntity t) -> StageHelper.asPredicate(condition).test((Entity)t), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnKill(@Nullable BiPredicate<Player, LivingEntity> condition, String ... stages) {
        StageHelper.grantStageOnKill(condition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnKill(@Nullable BiPredicate<Player, LivingEntity> condition, @Nullable BiConsumer<Player, LivingEntity> hook, String ... stages) {
        CTEventManager.register(LivingDeathEvent.class, event -> {
            DamageSource source = event.getSource();
            if (source != null) {
                LivingEntity target = event.getEntity();
                Entity patt3322$temp = source.m_7639_();
                if (patt3322$temp instanceof ServerPlayer) {
                    ServerPlayer killingPlayer = (ServerPlayer)patt3322$temp;
                    if (target != null && (condition == null || condition.test((Player)killingPlayer, target)) && StageHelper.grantStages(killingPlayer, stages) && hook != null) {
                        hook.accept((Player)killingPlayer, target);
                    }
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(String[] targets, String ... stages) {
        StageHelper.grantStageOnDimension(targets, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(String[] targets, @Nullable DimensionHook hook, String ... stages) {
        StageHelper.grantStageOnDimension((Player p, ResourceLocation t, ResourceLocation f) -> Arrays.stream(targets).anyMatch(target -> target.equalsIgnoreCase(t.toString())), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(String targetTo, String ... stages) {
        StageHelper.grantStageOnDimension(targetTo, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(String targetTo, @Nullable DimensionHook hook, String ... stages) {
        StageHelper.grantStageOnDimension((Player p, ResourceLocation t, ResourceLocation f) -> targetTo.equalsIgnoreCase(t.toString()), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(@Nullable DimensionCondition condition, String ... stages) {
        StageHelper.grantStageOnDimension(condition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnDimension(@Nullable DimensionCondition condition, @Nullable DimensionHook hook, String ... stages) {
        CTEventManager.register(PlayerEvent.PlayerChangedDimensionEvent.class, event -> {
            ResourceLocation toDim = event.getTo().m_135782_();
            ResourceLocation fromDim = event.getFrom().m_135782_();
            Player patt5214$temp = event.getEntity();
            if (patt5214$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt5214$temp;
                if ((condition == null || condition.test((Player)player, toDim, fromDim)) && StageHelper.grantStages(player, stages) && hook != null) {
                    hook.accept((Player)player, toDim, fromDim);
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageOnJoin(String ... stages) {
        StageHelper.grantStageOnJoin(null, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnJoinWithCondition(@Nullable Predicate<Player> condition, String ... stages) {
        StageHelper.grantStageOnJoin(condition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnJoinWithHook(@Nullable Consumer<Player> hook, String ... stages) {
        StageHelper.grantStageOnJoin(null, hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnJoin(@Nullable Predicate<Player> condition, @Nullable Consumer<Player> hook, String ... stages) {
        CTEventManager.register(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            Player patt6312$temp = event.getEntity();
            if (patt6312$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt6312$temp;
                if ((condition == null || condition.test((Player)player)) && StageHelper.grantStages(player, stages) && hook != null) {
                    hook.accept((Player)player);
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageOnExactLevel(int level, String ... stages) {
        StageHelper.grantStageOnExactLevel(level, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnExactLevel(int level, @Nullable ObjIntConsumer<Player> hook, String ... stages) {
        StageHelper.grantStageOnLevel((int l) -> l == level, hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnLevel(int level, String ... stages) {
        StageHelper.grantStageOnLevel(level, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnLevel(int level, @Nullable ObjIntConsumer<Player> hook, String ... stages) {
        StageHelper.grantStageOnLevel((int l) -> l >= level, hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnLevel(IntPredicate levelCondition, String ... stages) {
        StageHelper.grantStageOnLevel(levelCondition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnLevel(IntPredicate levelCondition, @Nullable ObjIntConsumer<Player> hook, String ... stages) {
        CTEventManager.register(PlayerXpEvent.LevelChange.class, event -> {
            int currentPlayerLevel = event.getEntity().f_36078_ + event.getLevels();
            Player patt7866$temp = event.getEntity();
            if (patt7866$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt7866$temp;
                if (levelCondition.test(currentPlayerLevel) && StageHelper.grantStages(player, stages) && hook != null) {
                    hook.accept((Player)player, currentPlayerLevel);
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(String targetId, String ... stages) {
        StageHelper.grantStageOnAdvancement(targetId, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(String targetId, @Nullable BiConsumer<Player, ResourceLocation> hook, String ... stages) {
        StageHelper.grantStageOnAdvancement((ResourceLocation adv) -> targetId.equalsIgnoreCase(adv.toString()), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(String[] targetIds, String ... stages) {
        StageHelper.grantStageOnAdvancement(targetIds, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(String[] targetIds, @Nullable BiConsumer<Player, ResourceLocation> hook, String ... stages) {
        StageHelper.grantStageOnAdvancement((ResourceLocation adv) -> Arrays.stream(targetIds).anyMatch(target -> target.equalsIgnoreCase(adv.toString())), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(Predicate<ResourceLocation> predicate, String ... stages) {
        StageHelper.grantStageOnAdvancement(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnAdvancement(Predicate<ResourceLocation> predicate, @Nullable BiConsumer<Player, ResourceLocation> hook, String ... stages) {
        CTEventManager.register(AdvancementEvent.AdvancementEarnEvent.class, event -> {
            Player patt9555$temp = event.getEntity();
            if (patt9555$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt9555$temp;
                if (predicate.test(event.getAdvancement().m_138327_()) && StageHelper.grantStages(player, stages) && hook != null) {
                    hook.accept((Player)player, event.getAdvancement().m_138327_());
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageWhenCrafting(IIngredient stack, String ... stages) {
        StageHelper.grantStageWhenCrafting(stack, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenCrafting(IIngredient stack, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        StageHelper.grantStageWhenCrafting(arg_0 -> ((IIngredient)stack).matches(arg_0), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenCrafting(Predicate<IItemStack> predicate, String ... stages) {
        StageHelper.grantStageWhenCrafting(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenCrafting(Predicate<IItemStack> predicate, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        CTEventManager.register(PlayerEvent.ItemCraftedEvent.class, event -> {
            MCItemStack output = new MCItemStack(event.getCrafting());
            Player patt10779$temp = event.getEntity();
            if (patt10779$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt10779$temp;
                if (predicate.test((IItemStack)output) && StageHelper.grantStages(player, stages) && hook != null) {
                    hook.accept((Player)player, (IItemStack)output);
                }
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageWhenSmelting(IIngredient stack, String ... stages) {
        StageHelper.grantStageWhenSmelting((Player player, IItemStack smelted) -> stack.matches(smelted), null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenSmelting(IIngredient stack, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        StageHelper.grantStageWhenSmelting((Player player, IItemStack smelted) -> stack.matches(smelted), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenSmelting(BiPredicate<Player, IItemStack> predicate, String ... stages) {
        StageHelper.grantStageWhenSmelting(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenSmelting(BiPredicate<Player, IItemStack> predicate, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        CTEventManager.register(PlayerEvent.ItemSmeltedEvent.class, event -> {
            ServerPlayer player;
            MCItemStack output = new MCItemStack(event.getSmelting());
            Player patt12042$temp = event.getEntity();
            if (patt12042$temp instanceof ServerPlayer && predicate.test((Player)(player = (ServerPlayer)patt12042$temp), (IItemStack)output) && StageHelper.grantStages(player, stages) && hook != null) {
                hook.accept((Player)player, (IItemStack)output);
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(MobEffect effect, String ... stages) {
        StageHelper.grantStageWhenBrewing(effect, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(MobEffect effect, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        StageHelper.grantStageWhenBrewing((Player player, IItemStack brewed) -> StageHelper.hasEffect(effect, PotionUtils.m_43547_((ItemStack)brewed.getInternal())), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(Potion potion, String ... stages) {
        StageHelper.grantStageWhenBrewing(potion, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(Potion potion, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        StageHelper.grantStageWhenBrewing((Player player, IItemStack brewed) -> PotionUtils.m_43579_((ItemStack)brewed.getInternal()) == potion, hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(IIngredient stack, String ... stages) {
        StageHelper.grantStageWhenBrewing((Player player, IItemStack brewed) -> stack.matches(brewed), stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(IIngredient stack, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        StageHelper.grantStageWhenBrewing((Player player, IItemStack brewed) -> stack.matches(brewed), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(BiPredicate<Player, IItemStack> predicate, String ... stages) {
        StageHelper.grantStageWhenBrewing(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenBrewing(BiPredicate<Player, IItemStack> predicate, @Nullable BiConsumer<Player, IItemStack> hook, String ... stages) {
        CTEventManager.register(PlayerBrewedPotionEvent.class, event -> {
            ServerPlayer player;
            MCItemStack output = new MCItemStack(event.getStack());
            Player patt14195$temp = event.getEntity();
            if (patt14195$temp instanceof ServerPlayer && predicate.test((Player)(player = (ServerPlayer)patt14195$temp), (IItemStack)output) && StageHelper.grantStages(player, stages) && hook != null) {
                hook.accept((Player)player, (IItemStack)output);
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageWhenFishing(IIngredient ingredient, String ... stages) {
        StageHelper.grantStageWhenFishing((Player player, net.minecraft.world.entity.projectile.FishingHook bobber, List<ItemStack> drops) -> StageHelper.anyMatch(ingredient, drops), null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenFishing(IIngredient ingredient, @Nullable FishingHook hook, String ... stages) {
        StageHelper.grantStageWhenFishing((Player player, net.minecraft.world.entity.projectile.FishingHook bobber, List<ItemStack> drops) -> StageHelper.anyMatch(ingredient, drops), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenFishing(FishingCondition predicate, @Nullable FishingHook hook, String ... stages) {
        CTEventManager.register(ItemFishedEvent.class, event -> {
            ServerPlayer player;
            NonNullList output = event.getDrops();
            Player patt15213$temp = event.getEntity();
            if (patt15213$temp instanceof ServerPlayer && predicate.test((Player)(player = (ServerPlayer)patt15213$temp), event.getHookEntity(), (List<ItemStack>)output) && StageHelper.grantStages(player, stages) && hook != null) {
                hook.accept((Player)player, event.getHookEntity(), (List<ItemStack>)output);
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageWhenPickedUp(IIngredient ingredient, String ... stages) {
        StageHelper.grantStageWhenPickedUp(ingredient, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenPickedUp(IIngredient ingredient, @Nullable BiConsumer<Player, ItemEntity> hook, String ... stages) {
        StageHelper.grantStageWhenPickedUp((Player player, IItemStack stack) -> ingredient.matches(stack), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenPickedUp(BiPredicate<Player, IItemStack> predicate, String ... stages) {
        StageHelper.grantStageWhenPickedUp(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageWhenPickedUp(BiPredicate<Player, IItemStack> predicate, @Nullable BiConsumer<Player, ItemEntity> hook, String ... stages) {
        CTEventManager.register(PlayerEvent.ItemPickupEvent.class, event -> {
            ServerPlayer player;
            MCItemStack output = new MCItemStack(event.getStack());
            Player patt16503$temp = event.getEntity();
            if (patt16503$temp instanceof ServerPlayer && predicate.test((Player)(player = (ServerPlayer)patt16503$temp), (IItemStack)output) && StageHelper.grantStages(player, stages) && hook != null) {
                hook.accept((Player)player, event.getOriginalEntity());
            }
        });
    }

    @ZenCodeType.Method
    public static void grantStageOnCrit(CTEntityIngredient condition, String ... stages) {
        StageHelper.grantStageOnCrit(condition, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnCrit(CTEntityIngredient condition, @Nullable BiConsumer<Player, Entity> hook, String ... stages) {
        StageHelper.grantStageOnCrit((Player player, Entity target) -> StageHelper.asPredicate(condition).test((Entity)target), hook, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnCrit(BiPredicate<Player, Entity> predicate, String ... stages) {
        StageHelper.grantStageOnCrit(predicate, null, stages);
    }

    @ZenCodeType.Method
    public static void grantStageOnCrit(BiPredicate<Player, Entity> predicate, @Nullable BiConsumer<Player, Entity> hook, String ... stages) {
        CTEventManager.register(CriticalHitEvent.class, event -> {
            ServerPlayer player;
            Player patt17645$temp = event.getEntity();
            if (patt17645$temp instanceof ServerPlayer && predicate.test((Player)(player = (ServerPlayer)patt17645$temp), event.getTarget()) && StageHelper.grantStages(player, stages) && hook != null) {
                hook.accept((Player)player, event.getTarget());
            }
        });
    }

    private static boolean grantStages(ServerPlayer player, String ... stages) {
        boolean result = false;
        IStageData data = GameStageHelper.getPlayerData((Player)player);
        if (data != null) {
            for (String stageName : stages) {
                if (data.hasStage(stageName)) continue;
                GameStageHelper.addStage(player, stageName);
                result = true;
            }
        }
        return result;
    }

    private static Predicate<Entity> asPredicate(CTEntityIngredient ingredient) {
        return (Predicate)ingredient.mapTo(internal -> toTest -> toTest.m_6095_() == internal, (internal, amount) -> toTest -> toTest.m_6095_().m_204039_(internal) && amount <= 1, stream -> toTest -> stream.anyMatch(sub -> sub.test(toTest)));
    }

    private static boolean anyMatch(IIngredient ingredient, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!ingredient.matches((IItemStack)new MCItemStack(stack))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEffect(MobEffect effect, List<MobEffectInstance> toTest) {
        for (MobEffectInstance effectToTest : toTest) {
            if (effectToTest.m_19544_() != effect) continue;
            return true;
        }
        return false;
    }
}

