/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.lib.metaphysics.IAutomataCoreTier;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralCheck;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public abstract class AutomataCorePeripheral
extends BasePeripheral<TurtlePeripheralOwner> {
    public static final String ATTR_STORING_TOOL_DURABILITY = "storingToolDurability";
    private final IAutomataCoreTier tier;
    private final Map<String, Boolean> attributes = new HashMap<String, Boolean>();

    protected AutomataCorePeripheral(String type, ITurtleAccess turtle, TurtleSide side, IAutomataCoreTier tier) {
        super(type, new TurtlePeripheralOwner(turtle, side));
        ((TurtlePeripheralOwner)this.owner).attachFuel(tier.getMaxFuelConsumptionRate());
        ((TurtlePeripheralOwner)this.owner).attachOperation(this.possibleOperations());
        this.tier = tier;
    }

    public void addRotationCycle() {
        this.addRotationCycle(1);
    }

    public void addRotationCycle(int count) {
        DataStorageUtil.RotationCharge.addCycles(this.owner, count);
    }

    public List<IPeripheralOperation<?>> possibleOperations() {
        return new ArrayList();
    }

    @Override
    public Map<String, Object> getPeripheralConfiguration() {
        Map<String, Object> data = super.getPeripheralConfiguration();
        data.put("interactionRadius", this.getInteractionRadius());
        return data;
    }

    public final int getInteractionRadius() {
        return this.tier.getInteractionRadius();
    }

    public SingleOperationContext forUnknownDistance() {
        return new SingleOperationContext(1, this.getInteractionRadius());
    }

    public SingleOperationContext toDistance(BlockPos pos) {
        return new SingleOperationContext(1, this.getPos().m_123333_((Vec3i)pos));
    }

    public <T> MethodResult withOperation(IPeripheralOperation<T> operation, T context, IPeripheralFunction<T, MethodResult> function, IPeripheralCheck<T> check) throws LuaException {
        return this.withOperation(operation, context, check, function, ignored -> this.addRotationCycle());
    }

    public MethodResult withOperation(SingleOperation operation, IPeripheralFunction<SingleOperationContext, MethodResult> function) throws LuaException {
        return this.withOperation(operation, this.forUnknownDistance(), function, null);
    }

    public MethodResult withOperation(SingleOperation operation, IPeripheralFunction<SingleOperationContext, MethodResult> function, IPeripheralCheck<SingleOperationContext> check) throws LuaException {
        return this.withOperation(operation, this.forUnknownDistance(), function, check);
    }

    public boolean hasAttribute(String attribute) {
        return this.attributes.getOrDefault(attribute, false);
    }

    public void setAttribute(String attribute) {
        this.attributes.put(attribute, true);
    }
}

