/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import architectury_inject_KubeJS119_common_daeb091d4e6f4102926501b819ff9bc4_e8518068e026f1598c5e6480f3a3ddb2ac591a22dbf53551bb2e039321200a60kubejs190262build69devjar.PlatformMethods;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.platform.MiscPlatformHelper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PlatformWrapper {
    private static Map<String, ModInfo> allMods;

    public static String getName() {
        if (PlatformWrapper.isDevelopmentEnvironment()) {
            if (PlatformWrapper.isForge()) {
                return "forge";
            }
            if (PlatformWrapper.isFabric()) {
                return "fabric";
            }
            return "unknown (userdev?)";
        }
        return PlatformMethods.getCurrentTarget();
    }

    public static boolean isForge() {
        return Platform.isForge();
    }

    public static boolean isFabric() {
        return Platform.isFabric();
    }

    public static String getMcVersion() {
        return "1.19.2";
    }

    public static Set<String> getList() {
        return PlatformWrapper.getMods().keySet();
    }

    public static String getModVersion() {
        return KubeJS.thisMod.getVersion();
    }

    public static boolean isLoaded(String modId) {
        return PlatformWrapper.getMods().containsKey(modId);
    }

    public static ModInfo getInfo(String modID) {
        return PlatformWrapper.getMods().computeIfAbsent(modID, ModInfo::new);
    }

    public static Map<String, ModInfo> getMods() {
        if (allMods == null) {
            allMods = new LinkedHashMap<String, ModInfo>();
            for (Mod mod : Platform.getMods()) {
                ModInfo info = new ModInfo(mod.getModId());
                info.name = mod.getName();
                info.version = mod.getVersion();
                allMods.put(info.id, info);
            }
        }
        return allMods;
    }

    public static boolean isDevelopmentEnvironment() {
        return Platform.isDevelopmentEnvironment();
    }

    public static boolean isClientEnvironment() {
        return Platform.getEnvironment() == Env.CLIENT;
    }

    public static void setModName(String modId, String name) {
        PlatformWrapper.getInfo(modId).setName(name);
    }

    public static int getMinecraftVersion() {
        return 1902;
    }

    public static String getMinecraftVersionString() {
        return "1.19.2";
    }

    public static boolean isGeneratingData() {
        return MiscPlatformHelper.get().isDataGen();
    }

    public static void breakpoint(Object ... args) {
        KubeJS.LOGGER.info(Arrays.stream(args).map(String::valueOf).collect(Collectors.joining(", ")));
    }

    public static class ModInfo {
        private final String id;
        private String name;
        private String version;
        private String customName;

        public ModInfo(String i) {
            this.name = this.id = i;
            this.version = "0.0.0";
            this.customName = "";
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
            this.customName = n;
            MiscPlatformHelper.get().setModName(this, this.name);
        }

        public String getVersion() {
            return this.version;
        }

        public String getCustomName() {
            return this.customName;
        }
    }
}

