/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.RecipeTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.crafting.recipe.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BlockEntityMechanicalManaPool
extends RecipeTile<ManaInfusionRecipe> {
    private static List<Item> CACHED_CATALYSTS;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)3).validator(stack -> this.getCatalysts().contains(stack.m_41720_()), new int[]{0}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)BotaniaRecipeTypes.MANA_INFUSION_TYPE, (ItemStack)stack), new int[0]).slotLimit(1, new int[]{0}).output(new int[]{2}).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
        this.needsRecipeUpdate();
    }).build();
    private int cooldown = 0;
    private boolean checkWithCatalyst = false;

    public BlockEntityMechanicalManaPool(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, BotaniaRecipeTypes.MANA_INFUSION_TYPE, pos, state, LibXServerConfig.MaxManaCapacity.mechanicalManaPool, 1, 2);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateRecipeIfNeeded();
            if (this.cooldown > 0) {
                --this.cooldown;
                this.m_6596_();
                this.setDispatchable();
            }
            if (this.cooldown <= 0 && this.recipe != null) {
                this.craftRecipe();
            }
        } else if (this.f_58857_ != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory) {
            double particleChance = (double)this.getCurrentMana() / (double)this.getMaxMana() * 0.1;
            if (Math.random() < particleChance) {
                float red = 0.0f;
                float green = 0.7764706f;
                float blue = 1.0f;
                WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)red, (float)green, (float)blue, (float)2.0f);
                this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, (double)this.f_58858_.m_123342_() + 0.5 + this.f_58857_.f_46441_.m_188500_() * 0.25, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, 0.0, (double)(this.f_58857_.f_46441_.m_188501_() / 25.0f), 0.0);
            }
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot == 2;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected void updateRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        this.recipe = null;
        this.checkWithCatalyst = true;
        super.updateRecipe(usedStacks);
        this.checkWithCatalyst = false;
        if (this.recipe == null) {
            super.updateRecipe(usedStacks);
        }
    }

    @Override
    protected boolean matchRecipe(ManaInfusionRecipe recipe, List<ItemStack> stacks) {
        Block catalyst;
        if (recipe.getManaToConsume() > this.getCurrentMana()) {
            return false;
        }
        Item catalystItem = this.checkWithCatalyst && !this.inventory.getStackInSlot(0).m_41619_() ? this.inventory.getStackInSlot(0).m_41720_() : null;
        Block block = catalyst = catalystItem == null ? null : Block.m_49814_(catalystItem);
        if (catalyst == null && recipe.getRecipeCatalyst() != null) {
            return false;
        }
        if (!(catalyst == null || recipe.getRecipeCatalyst() != null && recipe.getRecipeCatalyst().test(catalyst.m_49966_()))) {
            return false;
        }
        return super.matchRecipe(recipe, stacks);
    }

    @Override
    protected void onCrafted(ManaInfusionRecipe recipe) {
        this.cooldown = Math.max(1, LibXServerConfig.WorkingDurationMultiplier.mechanicalManaPool);
        this.receiveMana(-recipe.getManaToConsume());
    }

    @Override
    public int getComparatorOutput() {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            return 0;
        }
        Item item = this.inventory.getStackInSlot(0).m_41720_();
        if (this.getCatalysts().contains(item)) {
            return Mth.m_14045_((int)(1 + this.getCatalysts().indexOf(item)), (int)0, (int)15);
        }
        return 0;
    }

    @Override
    public void receiveMana(int i) {
        if (this.inventory.getStackInSlot(0).m_41720_() == BotaniaBlocks.manaVoid.m_5456_()) {
            super.receiveMana(Math.min(i, this.getAvailableSpaceForMana()));
        } else {
            super.receiveMana(i);
        }
        if (this.recipe == null && !this.inventory.getStackInSlot(1).m_41619_()) {
            this.needsRecipeUpdate();
        }
    }

    @Override
    public boolean isFull() {
        return this.inventory.getStackInSlot(0).m_41720_() != BotaniaBlocks.manaVoid.m_5456_() && super.isFull();
    }

    @Override
    public int getAvailableSpaceForMana() {
        return this.inventory.getStackInSlot(0).m_41720_() == BotaniaBlocks.manaVoid.m_5456_() ? this.getMaxMana() : super.getAvailableSpaceForMana();
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown = nbt.m_128451_("cooldown");
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("cooldown", this.cooldown);
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.cooldown = nbt.m_128451_("cooldown");
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("cooldown", this.cooldown);
        return nbt;
    }

    public static void invalidateCatalysts() {
        CACHED_CATALYSTS = null;
    }

    public List<Item> getCatalysts() {
        if (CACHED_CATALYSTS == null) {
            if (this.f_58857_ == null) {
                return List.of();
            }
            ArrayList catalysts = new ArrayList();
            this.f_58857_.m_7465_().m_44013_(BotaniaRecipeTypes.MANA_INFUSION_TYPE).forEach(recipe -> {
                if (recipe.getRecipeCatalyst() != null) {
                    recipe.getRecipeCatalyst().getDisplayedStacks().stream().map(ItemStack::m_41720_).forEach(item -> {
                        if (!catalysts.contains(item)) {
                            catalysts.add(item);
                        }
                    });
                }
            });
            CACHED_CATALYSTS = List.copyOf(catalysts);
        }
        return CACHED_CATALYSTS;
    }
}

