/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.data.ModEntityTypeTagsProvider;
import fuzs.mutantmonsters.data.ModItemTagsProvider;
import fuzs.mutantmonsters.data.ModLootTableProvider;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModRegistryForge;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.core.ContentRegistrationFlags;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="mutantmonsters")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MutantMonstersForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CommonFactories.INSTANCE.modConstructor("mutantmonsters", new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOMES}).accept(new MutantMonsters());
        ModRegistryForge.touch();
        MutantMonstersForge.registerCapabilities();
        MutantMonstersForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.SEISMIC_WAVES_CAPABILITY, (CapabilityToken)new CapabilityToken<SeismicWavesCapability>(){});
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> EntityEventsHandler.onLivingHurt(evt.getEntity(), evt.getSource(), evt.getAmount()));
        MinecraftForge.EVENT_BUS.addListener(evt -> PlayerEventsHandler.onItemUseTick(evt.getEntity(), evt.getItem(), evt.getDuration()).ifPresent(arg_0 -> ((LivingEntityUseItemEvent.Tick)evt).setDuration(arg_0)));
        MinecraftForge.EVENT_BUS.addListener(evt -> PlayerEventsHandler.onArrowLoose(evt.getEntity(), evt.getBow(), evt.getLevel(), evt.getCharge(), evt.hasAmmo()).ifPresent(unit -> evt.setCanceled(true)));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            InteractionResult result = EntityEventsHandler.onEntityInteract(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), new EntityHitResult(evt.getTarget(), evt.getLocalPos().m_82549_(evt.getTarget().m_20182_())));
            if (result != InteractionResult.PASS) {
                evt.setCancellationResult(result);
                evt.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.END) {
                PlayerEventsHandler.onPlayerTick$End(evt.player);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> PlayerEventsHandler.onItemToss(evt.getEntity(), evt.getPlayer()).ifPresent(unit -> evt.setCanceled(true)));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            Level patt4320$temp = evt.getLevel();
            if (patt4320$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt4320$temp;
                EntityEventsHandler.onEntityJoinServerLevel(evt.getEntity(), level);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> EntityEventsHandler.onLivingDrops(evt.getEntity(), evt.getSource(), evt.getDrops(), evt.getLootingLevel(), evt.isRecentlyHit()).ifPresent(unit -> evt.setCanceled(true)));
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent evt) {
        evt.put((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.get(), MutantSkeleton.registerAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0).m_22265_());
        evt.put((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.get(), MutantZombie.registerAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0).m_22265_());
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.m_236039_(true, (DataProvider)new ModEntityTypeTagsProvider(dataGenerator, "mutantmonsters", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModItemTagsProvider(dataGenerator, "mutantmonsters", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModLootTableProvider(dataGenerator));
    }
}

