/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.model.MutantCrossbowModel;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantSkeletonModel
extends EntityModel<MutantSkeleton> {
    private final Animator animator = new Animator();
    private final List<ModelPart> parts;
    private final ModelPart skeleBase;
    private final ModelPart pelvis;
    private final ModelPart waist;
    private final Spine[] spine = new Spine[3];
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart innerhead;
    private final ModelPart jaw;
    private final ModelPart shoulder1;
    private final ModelPart shoulder2;
    private final ModelPart arm1;
    private final ModelPart innerarm1;
    private final ModelPart arm2;
    private final ModelPart innerarm2;
    private final ModelPart forearm1;
    private final ModelPart innerforearm1;
    private final ModelPart forearm2;
    private final ModelPart innerforearm2;
    private final ModelPart leg1;
    private final ModelPart innerleg1;
    private final ModelPart leg2;
    private final ModelPart innerleg2;
    private final ModelPart foreleg1;
    private final ModelPart innerforeleg1;
    private final ModelPart foreleg2;
    private final ModelPart innerforeleg2;
    private final MutantCrossbowModel crossbow;
    private float partialTick;

    public MutantSkeletonModel(ModelPart modelPart, ModelPart crossbowModelPart) {
        this.parts = (List)Stream.of(modelPart, crossbowModelPart).flatMap(ModelPart::m_171331_).collect(ImmutableList.toImmutableList());
        this.skeleBase = modelPart.m_171324_("base");
        this.pelvis = this.skeleBase.m_171324_("pelvis");
        modelPart = this.waist = this.pelvis.m_171324_("waist");
        for (int i = 0; i < 3; ++i) {
            this.spine[i] = new Spine(modelPart, "" + (i + 1));
            modelPart = this.spine[i].middle;
        }
        this.neck = modelPart.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.innerhead = this.head.m_171324_("inner_head");
        this.jaw = this.innerhead.m_171324_("jaw");
        this.shoulder1 = modelPart.m_171324_("shoulder1");
        this.shoulder2 = modelPart.m_171324_("shoulder2");
        this.arm1 = this.shoulder1.m_171324_("arm1");
        this.innerarm1 = this.arm1.m_171324_("inner_arm1");
        this.arm2 = this.shoulder2.m_171324_("arm2");
        this.innerarm2 = this.arm2.m_171324_("inner_arm2");
        this.forearm1 = this.innerarm1.m_171324_("fore_arm1");
        this.innerforearm1 = this.forearm1.m_171324_("inner_fore_arm1");
        this.forearm2 = this.innerarm2.m_171324_("fore_arm2");
        this.innerforearm2 = this.forearm2.m_171324_("inner_fore_arm2");
        this.leg1 = this.pelvis.m_171324_("leg1");
        this.innerleg1 = this.leg1.m_171324_("inner_leg1");
        this.leg2 = this.pelvis.m_171324_("leg2");
        this.innerleg2 = this.leg2.m_171324_("inner_leg2");
        this.foreleg1 = this.innerleg1.m_171324_("fore_leg1");
        this.innerforeleg1 = this.foreleg1.m_171324_("inner_fore_leg1");
        this.foreleg2 = this.innerleg2.m_171324_("fore_leg2");
        this.innerforeleg2 = this.foreleg2.m_171324_("inner_fore_leg2");
        this.crossbow = new MutantCrossbowModel(crossbowModelPart);
    }

    public static LayerDefinition createBodyLayer() {
        PartDefinition waist;
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition base = root.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition pelvis = base.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f), PartPose.f_171404_);
        PartDefinition middle = waist = pelvis.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        for (int i = 0; i < 3; ++i) {
            Spine.createSpineLayer(middle, i);
            middle = middle.m_171597_("middle" + (i + 1));
        }
        PartDefinition neck = middle.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition innerHead = head.m_171599_("inner_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.4f)), PartPose.f_171404_);
        innerHead.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(72, 0).m_171488_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)0.0f, (float)-0.2f, (float)3.5f));
        PartDefinition shoulder1 = middle.m_171599_("shoulder1", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171481_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.m_171419_((float)-7.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition shoulder2 = middle.m_171599_("shoulder2", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171480_().m_171481_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.m_171419_((float)7.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition arm1 = shoulder1.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(0, 28), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition innerArm1 = arm1.m_171599_("inner_arm1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition arm2 = shoulder2.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_(), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition innerArm2 = arm2.m_171599_("inner_arm2", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition foreArm1 = innerArm1.m_171599_("fore_arm1", CubeListBuilder.m_171558_().m_171514_(16, 28), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm1.m_171599_("inner_fore_arm1", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.f_171404_);
        PartDefinition foreArm2 = innerArm2.m_171599_("fore_arm2", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171480_(), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm2.m_171599_("inner_fore_arm2", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.f_171404_);
        PartDefinition leg1 = pelvis.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 28), PartPose.m_171419_((float)-2.5f, (float)-2.5f, (float)0.0f));
        PartDefinition innerLeg1 = leg1.m_171599_("inner_leg1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition leg2 = pelvis.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_(), PartPose.m_171419_((float)2.5f, (float)-2.5f, (float)0.0f));
        PartDefinition innerLeg2 = leg2.m_171599_("inner_leg2", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition foreLeg1 = innerLeg1.m_171599_("fore_leg1", CubeListBuilder.m_171558_().m_171514_(32, 28), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg1.m_171599_("inner_fore_leg1", CubeListBuilder.m_171558_().m_171514_(32, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition foreLeg2 = innerLeg2.m_171599_("fore_leg2", CubeListBuilder.m_171558_().m_171514_(32, 28).m_171480_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg2.m_171599_("inner_fore_leg2", CubeListBuilder.m_171558_().m_171514_(32, 28).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.skeleBase.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(MutantSkeleton entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.partialTick = Mth.m_14187_((float)ageInTicks);
        this.animator.update(entityIn, this.partialTick);
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        for (ModelPart renderer : this.parts) {
            renderer.f_104203_ = 0.0f;
            renderer.f_104204_ = 0.0f;
            renderer.f_104205_ = 0.0f;
        }
        this.skeleBase.f_104201_ = 3.0f;
        this.pelvis.f_104203_ = -0.31415927f;
        this.waist.f_104203_ = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setAngles(i == 1);
        }
        this.neck.f_104203_ = -0.1308997f;
        this.head.f_104203_ = -0.1308997f;
        this.jaw.f_104203_ = 0.09817477f;
        this.shoulder1.f_104203_ = -0.7853982f;
        this.shoulder2.f_104203_ = -0.7853982f;
        this.innerarm1.f_104203_ = 0.5235988f;
        this.innerarm1.f_104205_ = 0.31415927f;
        this.innerarm2.f_104203_ = 0.5235988f;
        this.innerarm2.f_104205_ = -0.31415927f;
        this.innerforearm1.f_104203_ = -0.5235988f;
        this.innerforearm2.f_104203_ = -0.5235988f;
        this.leg1.f_104203_ = -0.2617994f - this.pelvis.f_104203_;
        this.leg1.f_104205_ = 0.19634955f;
        this.leg2.f_104203_ = -0.2617994f - this.pelvis.f_104203_;
        this.leg2.f_104205_ = -0.19634955f;
        this.foreleg1.f_104205_ = -0.1308997f;
        this.innerforeleg1.f_104203_ = 0.31415927f;
        this.foreleg2.f_104205_ = 0.1308997f;
        this.innerforeleg2.f_104203_ = 0.31415927f;
        this.crossbow.setAngles((float)Math.PI);
        this.crossbow.rotateRope();
    }

    private void animate(MutantSkeleton skele, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkAnim1 = Mth.m_14031_((float)(limbSwing * 0.5f));
        float walkAnim2 = Mth.m_14031_((float)(limbSwing * 0.5f - 1.1f));
        float breatheAnim = Mth.m_14031_((float)(ageInTicks * 0.1f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (skele.getAnimation() == MutantSkeleton.MELEE_ANIMATION) {
            this.animateMelee(skele.getAnimationTick(), skele.m_21526_());
            this.crossbow.rotateRope();
            scale = 1.0f - Mth.m_14036_((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
        } else if (skele.getAnimation() == MutantSkeleton.SHOOT_ANIMATION) {
            this.animateShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.m_21526_());
            scale = 1.0f - Mth.m_14036_((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (skele.getAnimation() == MutantSkeleton.MULTI_SHOT_ANIMATION) {
            this.animateMultiShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.m_21526_());
            scale = 1.0f - Mth.m_14036_((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnimation(MutantSkeleton.CONSTRICT_RIBS_ANIMATION)) {
            this.animateConstrict();
            this.crossbow.rotateRope();
            scale = 1.0f - Mth.m_14036_((float)((float)skele.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else {
            this.crossbow.rotateRope();
        }
        this.skeleBase.f_104201_ -= (-0.5f + Math.abs(walkAnim1)) * limbSwingAmount;
        this.spine[0].middle.f_104204_ -= walkAnim1 * 0.06f * limbSwingAmount;
        this.arm1.f_104203_ -= walkAnim1 * 0.9f * limbSwingAmount;
        this.arm2.f_104203_ += walkAnim1 * 0.9f * limbSwingAmount;
        this.leg1.f_104203_ += (0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.leg2.f_104203_ -= (-0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.innerforeleg1.f_104203_ += (0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        this.innerforeleg2.f_104203_ -= (-0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        for (Spine spine : this.spine) {
            spine.animate(breatheAnim);
        }
        this.head.f_104203_ -= breatheAnim * 0.02f;
        this.jaw.f_104203_ += breatheAnim * 0.04f + 0.04f;
        this.arm1.f_104205_ += breatheAnim * 0.025f;
        this.arm2.f_104205_ -= breatheAnim * 0.025f;
        this.innerhead.f_104203_ += facePitch;
        this.innerhead.f_104204_ += faceYaw;
    }

    private void animateMelee(int fullTick, boolean leftHanded) {
        int offset;
        ModelPart meleeArm = leftHanded ? this.arm2 : this.arm1;
        ModelPart offArm = leftHanded ? this.arm1 : this.arm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 3) {
            float tick = ((float)fullTick + this.partialTick) / 3.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += f * (float)Math.PI / 16.0f * (float)offset;
            }
            meleeArm.f_104204_ += f * (float)Math.PI / 10.0f * (float)offset;
            meleeArm.f_104205_ += f * (float)Math.PI / 4.0f * (float)offset;
            offArm.f_104205_ += f * (float)(-Math.PI) / 16.0f * (float)offset;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 3) + this.partialTick) / 2.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += (f * 0.5890486f - 0.3926991f) * (float)offset;
            }
            meleeArm.f_104204_ += (f * 2.7307692f - 2.41661f) * (float)offset;
            meleeArm.f_104205_ += (f * 1.1780972f - 0.3926991f) * (float)offset;
            offArm.f_104205_ += -0.19634955f * (float)offset;
        } else if (fullTick < 8) {
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += -0.3926991f * (float)offset;
            }
            meleeArm.f_104204_ += -2.41661f * (float)offset;
            meleeArm.f_104205_ += -0.3926991f * (float)offset;
            offArm.f_104205_ += -0.19634955f * (float)offset;
        } else if (fullTick < 14) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 6.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += f * (float)(-Math.PI) / 8.0f * (float)offset;
            }
            meleeArm.f_104204_ += f * (float)(-Math.PI) / 1.3f * (float)offset;
            meleeArm.f_104205_ += f * (float)(-Math.PI) / 8.0f * (float)offset;
            offArm.f_104205_ += f * (float)(-Math.PI) / 16.0f * (float)offset;
        }
    }

    private void animateShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        int offset;
        ModelPart drawingArm = leftHanded ? this.arm2 : this.arm1;
        ModelPart holdingArm = leftHanded ? this.arm1 : this.arm2;
        ModelPart innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
        ModelPart innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
        ModelPart drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
        ModelPart holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 5) {
            float tick = ((float)fullTick + this.partialTick) / 5.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            innerDrawingArm.f_104203_ += -f * (float)Math.PI / 4.0f;
            drawingArm.f_104204_ += -f * (float)Math.PI / 2.0f * (float)offset;
            drawingArm.f_104205_ += f * (float)Math.PI / 16.0f * (float)offset;
            drawingForearm.f_104203_ += f * (float)Math.PI / 7.0f;
            innerHoldingArm.f_104203_ += -f * (float)Math.PI / 4.0f;
            holdingArm.f_104204_ += f * (float)Math.PI / 2.0f * (float)offset;
            holdingArm.f_104205_ += -f * (float)Math.PI / 16.0f * (float)offset;
            innerHoldingArm.f_104205_ += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.f_104203_ += -f * (float)Math.PI / 6.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 5) + this.partialTick) / 7.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            float f1s = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.innerhead.f_104204_ += f1 * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += -f1 * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.f_104203_ += f1 * facePitch / 3.0f;
                spine.middle.f_104204_ += f1 * faceYaw / 3.0f;
            }
            innerDrawingArm.f_104203_ += f * 0.2617994f - 1.0471976f;
            drawingArm.f_104204_ += (f * -0.9424778f - 0.62831855f) * (float)offset;
            drawingArm.f_104205_ += (f * -0.850848f + 1.0471976f) * (float)offset;
            drawingForearm.f_104203_ += 0.44879895f;
            innerHoldingArm.f_104203_ += f * 1.8325956f - 2.6179938f;
            holdingArm.f_104204_ += (f * 0.9424778f + 0.62831855f) * (float)offset;
            holdingArm.f_104205_ += (f * 0.850848f - 1.0471976f) * (float)offset;
            innerHoldingArm.f_104205_ += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.f_104203_ += f * 0.10471976f - 0.62831855f;
            this.crossbow.middle1.f_104203_ += -f1s * (float)Math.PI / 16.0f;
            this.crossbow.side1.f_104203_ += -f1s * (float)Math.PI / 24.0f;
            this.crossbow.middle2.f_104203_ += f1s * (float)Math.PI / 16.0f;
            this.crossbow.side2.f_104203_ += f1s * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.f_104203_ += f1s * (float)Math.PI / 6.0f;
            this.crossbow.rope2.f_104203_ += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 26) {
            this.innerhead.f_104204_ += 0.7853982f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += -0.2617994f * (float)offset;
                spine.middle.f_104203_ += facePitch / 3.0f;
                spine.middle.f_104204_ += faceYaw / 3.0f;
            }
            innerDrawingArm.f_104203_ += -1.0471976f;
            drawingArm.f_104204_ += -0.62831855f * (float)offset;
            drawingArm.f_104205_ += (float)offset;
            drawingForearm.f_104203_ += 0.44879895f;
            innerHoldingArm.f_104203_ += -2.6179938f;
            holdingArm.f_104204_ += 0.62831855f * (float)offset;
            holdingArm.f_104205_ += -1.0471976f * (float)offset;
            holdingforearm.f_104203_ += -0.62831855f;
            float tick = Mth.m_14036_((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.crossbow.middle1.f_104203_ += -f * (float)Math.PI / 16.0f;
            this.crossbow.side1.f_104203_ += -f * (float)Math.PI / 24.0f;
            this.crossbow.middle2.f_104203_ += f * (float)Math.PI / 16.0f;
            this.crossbow.side2.f_104203_ += f * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.f_104203_ += f * (float)Math.PI / 6.0f;
            this.crossbow.rope2.f_104203_ += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 26) + this.partialTick) / 4.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.innerhead.f_104204_ += f * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.f_104204_ += -f * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.f_104203_ += f * facePitch / 3.0f;
                spine.middle.f_104204_ += f * faceYaw / 3.0f;
            }
            innerDrawingArm.f_104203_ += -f * (float)Math.PI / 3.0f;
            drawingArm.f_104204_ += -f * (float)Math.PI / 5.0f * (float)offset;
            drawingArm.f_104205_ += f * (float)Math.PI / 3.0f * (float)offset;
            drawingForearm.f_104203_ += f * (float)Math.PI / 7.0f;
            innerHoldingArm.f_104203_ += -f * (float)Math.PI / 1.2f;
            holdingArm.f_104204_ += f * (float)Math.PI / 5.0f * (float)offset;
            holdingArm.f_104205_ += -f * (float)Math.PI / 3.0f * (float)offset;
            holdingforearm.f_104203_ += -f * (float)Math.PI / 5.0f;
            this.crossbow.rotateRope();
        }
    }

    private void animateMultiShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        if (fullTick < 10) {
            float tick = ((float)fullTick + this.partialTick) / 10.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.f_104201_ += f * 3.5f;
            this.spine[0].middle.f_104203_ += f * (float)Math.PI / 6.0f;
            this.head.f_104203_ += -f * (float)Math.PI / 4.0f;
            this.arm1.f_104203_ += f * (float)Math.PI / 6.0f;
            this.arm1.f_104205_ += f * (float)Math.PI / 16.0f;
            this.arm2.f_104203_ += f * (float)Math.PI / 6.0f;
            this.arm2.f_104205_ += -f * (float)Math.PI / 16.0f;
            this.leg1.f_104203_ += -f * (float)Math.PI / 8.0f;
            this.leg2.f_104203_ += -f * (float)Math.PI / 8.0f;
            this.innerforeleg1.f_104203_ += f * (float)Math.PI / 4.0f;
            this.innerforeleg2.f_104203_ += f * (float)Math.PI / 4.0f;
            this.crossbow.rotateRope();
        } else {
            int offset;
            ModelPart drawingArm = leftHanded ? this.arm2 : this.arm1;
            ModelPart holdingArm = leftHanded ? this.arm1 : this.arm2;
            ModelPart innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
            ModelPart innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
            ModelPart drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
            ModelPart holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
            int n = offset = leftHanded ? -1 : 1;
            if (fullTick < 12) {
                float tick = ((float)(fullTick - 10) + this.partialTick) / 2.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                this.skeleBase.f_104201_ += f * 3.5f;
                this.spine[0].middle.f_104203_ += f * (float)Math.PI / 6.0f;
                this.head.f_104203_ += -f * (float)Math.PI / 4.0f;
                drawingArm.f_104203_ += f * (float)Math.PI / 6.0f;
                drawingArm.f_104205_ += f * (float)Math.PI / 16.0f * (float)offset;
                holdingArm.f_104203_ += f * (float)Math.PI / 6.0f;
                holdingArm.f_104205_ += -f * (float)Math.PI / 16.0f * (float)offset;
                this.leg1.f_104203_ += -f * (float)Math.PI / 8.0f;
                this.leg2.f_104203_ += -f * (float)Math.PI / 8.0f;
                this.innerforeleg1.f_104203_ += f * (float)Math.PI / 4.0f;
                this.innerforeleg2.f_104203_ += f * (float)Math.PI / 4.0f;
                drawingArm.f_104205_ += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.f_104205_ += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.f_104205_ += -f1 * (float)Math.PI / 24.0f;
                this.leg2.f_104205_ += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.f_104205_ += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.f_104205_ += -f1 * (float)Math.PI / 64.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 14) {
                drawingArm.f_104205_ += -0.22439948f * (float)offset;
                holdingArm.f_104205_ += 0.22439948f * (float)offset;
                this.leg1.f_104205_ += -0.1308997f;
                this.leg2.f_104205_ += 0.1308997f;
                this.foreleg1.f_104205_ += 0.049087387f;
                this.foreleg2.f_104205_ += -0.049087387f;
                this.crossbow.rotateRope();
            } else if (fullTick < 17) {
                float tick = ((float)(fullTick - 14) + this.partialTick) / 3.0f;
                float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                drawingArm.f_104205_ += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.f_104205_ += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.f_104205_ += -f1 * (float)Math.PI / 24.0f;
                this.leg2.f_104205_ += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.f_104205_ += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.f_104205_ += -f1 * (float)Math.PI / 64.0f;
                innerDrawingArm.f_104203_ += -f * (float)Math.PI / 4.0f;
                drawingArm.f_104204_ += -f * (float)Math.PI / 2.0f * (float)offset;
                drawingArm.f_104205_ += f * (float)Math.PI / 16.0f * (float)offset;
                drawingForearm.f_104203_ += f * (float)Math.PI / 7.0f;
                innerHoldingArm.f_104203_ += -f * (float)Math.PI / 4.0f;
                holdingArm.f_104204_ += f * (float)Math.PI / 2.0f * (float)offset;
                holdingArm.f_104205_ += -f * (float)Math.PI / 16.0f * (float)offset;
                innerHoldingArm.f_104205_ += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.f_104203_ += -f * (float)Math.PI / 6.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 20) {
                float tick = ((float)(fullTick - 17) + this.partialTick) / 3.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                float f1s = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f * 0.4f));
                this.innerhead.f_104204_ += f1 * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.f_104204_ += -f1 * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.f_104203_ += f1 * facePitch / 3.0f;
                    spine.middle.f_104204_ += f1 * faceYaw / 3.0f;
                }
                innerDrawingArm.f_104203_ += f * 0.2617994f - 1.0471976f;
                drawingArm.f_104204_ += (f * -0.9424778f - 0.62831855f) * (float)offset;
                drawingArm.f_104205_ += (f * -0.850848f + 1.0471976f) * (float)offset;
                drawingForearm.f_104203_ += 0.44879895f;
                innerHoldingArm.f_104203_ += f * 1.8325956f - 2.6179938f;
                holdingArm.f_104204_ += (f * 0.9424778f + 0.62831855f) * (float)offset;
                holdingArm.f_104205_ += (f * 0.850848f - 1.0471976f) * (float)offset;
                innerHoldingArm.f_104205_ += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.f_104203_ += f * 0.10471976f - 0.62831855f;
                this.crossbow.middle1.f_104203_ += -f1s * (float)Math.PI / 16.0f;
                this.crossbow.side1.f_104203_ += -f1s * (float)Math.PI / 24.0f;
                this.crossbow.middle2.f_104203_ += f1s * (float)Math.PI / 16.0f;
                this.crossbow.side2.f_104203_ += f1s * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.f_104203_ += f1s * (float)Math.PI / 6.0f;
                this.crossbow.rope2.f_104203_ += -f1s * (float)Math.PI / 6.0f;
            } else if (fullTick < 24) {
                this.innerhead.f_104204_ += 0.7853982f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.f_104204_ += -0.2617994f * (float)offset;
                    spine.middle.f_104203_ += facePitch / 3.0f;
                    spine.middle.f_104204_ += faceYaw / 3.0f;
                }
                innerDrawingArm.f_104203_ += -1.0471976f;
                drawingArm.f_104204_ += -0.62831855f * (float)offset;
                drawingArm.f_104205_ += (float)offset;
                drawingForearm.f_104203_ += 0.44879895f;
                innerHoldingArm.f_104203_ += -2.6179938f;
                holdingArm.f_104204_ += 0.62831855f * (float)offset;
                holdingArm.f_104205_ += -1.0471976f * (float)offset;
                holdingforearm.f_104203_ += -0.62831855f;
                float tick = Mth.m_14036_((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.crossbow.middle1.f_104203_ += -f * (float)Math.PI / 16.0f;
                this.crossbow.side1.f_104203_ += -f * (float)Math.PI / 24.0f;
                this.crossbow.middle2.f_104203_ += f * (float)Math.PI / 16.0f;
                this.crossbow.side2.f_104203_ += f * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.f_104203_ += f * (float)Math.PI / 6.0f;
                this.crossbow.rope2.f_104203_ += -f * (float)Math.PI / 6.0f;
            } else if (fullTick < 28) {
                float tick = ((float)(fullTick - 24) + this.partialTick) / 4.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.innerhead.f_104204_ += f * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.f_104204_ += -f * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.f_104203_ += f * facePitch / 3.0f;
                    spine.middle.f_104204_ += f * faceYaw / 3.0f;
                }
                innerDrawingArm.f_104203_ += -f * (float)Math.PI / 3.0f;
                drawingArm.f_104204_ += -f * (float)Math.PI / 5.0f * (float)offset;
                drawingArm.f_104205_ += f * (float)Math.PI / 3.0f * (float)offset;
                drawingForearm.f_104203_ += f * (float)Math.PI / 7.0f;
                innerHoldingArm.f_104203_ += -f * (float)Math.PI / 1.2f;
                holdingArm.f_104204_ += f * (float)Math.PI / 5.0f * (float)offset;
                holdingArm.f_104205_ += -f * (float)Math.PI / 3.0f * (float)offset;
                holdingforearm.f_104203_ += -f * (float)Math.PI / 5.0f;
                this.crossbow.rotateRope();
            }
        }
    }

    private void animateConstrict() {
        float f;
        float tick;
        int animTick;
        this.animator.startPhase(5);
        this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
        for (animTick = 0; animTick < this.spine.length; ++animTick) {
            tick = animTick == 0 ? 0.3926991f : (animTick == 2 ? -0.3926991f : 0.0f);
            f = animTick == 1 ? 0.3926991f : 0.31415927f;
            this.animator.rotate(this.spine[animTick].side1[0], tick, f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[0], tick, -f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
        }
        this.animator.rotate(this.arm1, 0.0f, 0.0f, 0.8975979f);
        this.animator.rotate(this.arm2, 0.0f, 0.0f, -0.8975979f);
        this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(2);
        this.animator.startPhase(1);
        this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.15707964f, 0.0f, 0.0f);
        this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
        this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
        for (animTick = 0; animTick < this.spine.length; ++animTick) {
            tick = animTick == 0 ? 0.1308997f : (animTick == 2 ? -0.1308997f : 0.0f);
            f = animTick == 1 ? -0.17453294f : -0.22439948f;
            this.animator.rotate(this.spine[animTick].side1[0], tick - 0.08f, f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[0], tick + 0.08f, -f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
        }
        this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(4);
        this.animator.resetPhase(8);
        animTick = this.animator.getEntity().getAnimationTick();
    }

    public void translateHand(boolean leftHanded, PoseStack matrixStackIn) {
        this.skeleBase.m_104299_(matrixStackIn);
        this.pelvis.m_104299_(matrixStackIn);
        this.waist.m_104299_(matrixStackIn);
        for (Spine spine : this.spine) {
            spine.middle.m_104299_(matrixStackIn);
        }
        if (leftHanded) {
            this.shoulder2.m_104299_(matrixStackIn);
            this.arm2.m_104299_(matrixStackIn);
            this.innerarm2.m_104299_(matrixStackIn);
            this.forearm2.m_104299_(matrixStackIn);
            this.innerforearm2.m_104299_(matrixStackIn);
        } else {
            this.shoulder1.m_104299_(matrixStackIn);
            this.arm1.m_104299_(matrixStackIn);
            this.innerarm1.m_104299_(matrixStackIn);
            this.forearm1.m_104299_(matrixStackIn);
            this.innerforearm1.m_104299_(matrixStackIn);
        }
    }

    public MutantCrossbowModel getCrossbow() {
        return this.crossbow;
    }

    public static class Spine {
        public final ModelPart middle;
        public final ModelPart[] side1 = new ModelPart[3];
        public final ModelPart[] side2 = new ModelPart[3];

        public Spine(ModelPart modelPart, String indexString) {
            int i;
            modelPart = this.middle = modelPart.m_171324_("middle" + indexString);
            for (i = 0; i < 3; ++i) {
                modelPart = this.side1[i] = modelPart.m_171324_("side1" + (i + 1) + indexString);
            }
            modelPart = this.middle;
            for (i = 0; i < 3; ++i) {
                modelPart = this.side2[i] = modelPart.m_171324_("side2" + (i + 1) + indexString);
            }
        }

        public static void createSpineLayer(PartDefinition root, int index) {
            PartPose partPose = PartPose.f_171404_;
            if (index == 0) {
                partPose = PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f);
            } else if (index > 0) {
                partPose = PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f);
            }
            boolean skeletonPart = index < 0;
            String indexString = skeletonPart ? "" : "" + (index + 1);
            PartDefinition middle = root.m_171599_("middle" + indexString, CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-2.5f, -4.0f, -2.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.5f)), partPose);
            partPose = !skeletonPart ? PartPose.m_171419_((float)-3.0f, (float)-1.0f, (float)1.75f) : PartPose.f_171404_;
            PartDefinition side11 = middle.m_171599_("side11" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(skeletonPart ? 0.0f : -6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.25f)), partPose);
            PartDefinition side12 = side11.m_171599_("side12" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171480_().m_171488_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)(skeletonPart ? -0.5f : -6.5f), (float)0.0f, (float)0.0f));
            side12.m_171599_("side13" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)-6.4f, (float)0.0f, (float)0.0f));
            partPose = !skeletonPart ? PartPose.m_171419_((float)3.0f, (float)-1.0f, (float)1.75f) : PartPose.f_171404_;
            PartDefinition side21 = middle.m_171599_("side21" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171480_().m_171488_(skeletonPart ? -6.0f : 0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.25f)), partPose);
            PartDefinition side22 = side21.m_171599_("side22" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)(skeletonPart ? 0.5f : 6.5f), (float)0.0f, (float)0.0f));
            side22.m_171599_("side23" + indexString, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171480_().m_171488_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)6.4f, (float)0.0f, (float)0.0f));
        }

        public void setAngles(boolean middleSpine) {
            Animator.resetAngles(this.middle);
            Animator.resetAngles(this.side1);
            Animator.resetAngles(this.side2);
            this.middle.f_104203_ = 0.17453294f;
            this.side1[0].f_104204_ = -0.69813174f;
            this.side2[0].f_104204_ = 0.69813174f;
            this.side1[1].f_104204_ = -1.0471976f;
            this.side2[1].f_104204_ = 1.0471976f;
            this.side1[2].f_104204_ = -0.8975979f;
            this.side2[2].f_104204_ = 0.8975979f;
            if (middleSpine) {
                for (int i = 0; i < this.side1.length; ++i) {
                    this.side1[i].f_104204_ *= 0.98f;
                    this.side2[i].f_104204_ *= 0.98f;
                }
            }
        }

        public void animate(float breatheAnim) {
            this.side1[1].f_104204_ += breatheAnim * 0.02f;
            this.side2[1].f_104204_ -= breatheAnim * 0.02f;
        }
    }
}

