/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network;

import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.puzzleslib.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CAnimationMessage
implements Message<S2CAnimationMessage> {
    private int entityId;
    private int index;

    public S2CAnimationMessage() {
    }

    public S2CAnimationMessage(int entityId, int index) {
        this.entityId = entityId;
        this.index = index;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130130_(this.index);
    }

    public void read(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.index = buf.m_130242_();
    }

    public Message.MessageHandler<S2CAnimationMessage> makeHandler() {
        return new Message.MessageHandler<S2CAnimationMessage>(){

            public void handle(S2CAnimationMessage message, Player player, Object gameInstance) {
                ClientLevel world = ((Minecraft)gameInstance).f_91073_;
                Entity entity = world.m_6815_(message.entityId);
                if (entity instanceof AnimatedEntity) {
                    AnimatedEntity animatedEntity = (AnimatedEntity)entity;
                    if (message.index == -1) {
                        animatedEntity.setAnimation(Animation.NONE);
                    } else {
                        animatedEntity.setAnimation(animatedEntity.getAnimations()[message.index]);
                    }
                    animatedEntity.setAnimationTick(0);
                }
            }
        };
    }
}

