/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism;

import dev.architectury.platform.forge.EventBuses;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.ClientHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.GasComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.InfusionComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.PigmentComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.SlurryComponentHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="custommachinerymekanism")
public class CustomMachineryMekanism {
    public static final String MODID = "custommachinerymekanism";

    public CustomMachineryMekanism() {
        IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus((String)MODID, (IEventBus)MOD_BUS);
        Registration.MACHINE_COMPONENTS.register(MOD_BUS);
        Registration.GUI_ELEMENTS.register(MOD_BUS);
        Registration.REQUIREMENTS.register(MOD_BUS);
        Registration.DATAS.register(MOD_BUS);
        IEventBus FORGE_BUS = MinecraftForge.EVENT_BUS;
        FORGE_BUS.addGenericListener(BlockEntity.class, this::attachCapabilities);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::clientInit);
    }

    private void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof MachineTile) {
            final MachineTile machine = (MachineTile)object;
            event.addCapability(new ResourceLocation(MODID, "extension"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                    IMachineComponentManager manager = machine.getComponentManager();
                    if (capability == Capabilities.GAS_HANDLER) {
                        return manager.getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).map(handler -> ((GasComponentHandler)((Object)handler)).getSidedHandler(side)).orElse(LazyOptional.empty()).cast();
                    }
                    if (capability == Capabilities.INFUSION_HANDLER) {
                        return manager.getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).map(handler -> ((InfusionComponentHandler)((Object)handler)).getSidedHandler(side)).orElse(LazyOptional.empty()).cast();
                    }
                    if (capability == Capabilities.PIGMENT_HANDLER) {
                        return manager.getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).map(handler -> ((PigmentComponentHandler)((Object)handler)).getSidedHandler(side)).orElse(LazyOptional.empty()).cast();
                    }
                    if (capability == Capabilities.SLURRY_HANDLER) {
                        return manager.getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).map(handler -> ((SlurryComponentHandler)((Object)handler)).getSidedHandler(side)).orElse(LazyOptional.empty()).cast();
                    }
                    if (capability == Capabilities.HEAT_HANDLER) {
                        return manager.getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).map(component -> component.getHeatHandler(side)).orElse(LazyOptional.empty()).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

