/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.jei.wrapper;

import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinerymekanism.common.guielement.ChemicalGuiElement;
import java.util.Optional;
import java.util.function.BiFunction;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.jei.ChemicalStackRenderer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ChemicalIngredientWrapper<C extends Chemical<C>, S extends ChemicalStack<C>>
implements IJEIIngredientWrapper<S> {
    private final RequirementIOMode mode;
    private final C chemical;
    private final long amount;
    private final double chance;
    private final boolean isPerTick;
    private final String tank;
    private final IIngredientType<S> ingredientType;
    private final BiFunction<C, Long, S> stackBuilder;

    public ChemicalIngredientWrapper(RequirementIOMode mode, C chemical, long amount, double chance, boolean isPerTick, String tank, IIngredientType<S> ingredientType, BiFunction<C, Long, S> stackBuilder) {
        this.mode = mode;
        this.chemical = chemical;
        this.amount = amount;
        this.chance = chance;
        this.isPerTick = isPerTick;
        this.tank = tank;
        this.ingredientType = ingredientType;
        this.stackBuilder = stackBuilder;
    }

    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        if (!(element instanceof ChemicalGuiElement)) {
            return false;
        }
        ChemicalGuiElement chemicalElement = (ChemicalGuiElement)element;
        ChemicalStack ingredient = (ChemicalStack)this.stackBuilder.apply(this.chemical, this.amount);
        Optional template = helper.getComponentForElement((IComponentGuiElement)chemicalElement);
        if (chemicalElement.getID().equals(this.tank) || template.map(t -> t.canAccept((Object)ingredient, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.tank.isEmpty() || t.getId().equals(this.tank))).orElse(false).booleanValue()) {
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset, element.getY() - yOffset).setCustomRenderer(this.ingredientType, (IIngredientRenderer)new ChemicalStackRenderer(this.amount, element.getWidth() - 2, element.getHeight() - 2)).addIngredient(this.ingredientType, (Object)ingredient)).addTooltipCallback((view, tooltips) -> {
                if (this.isPerTick) {
                    tooltips.add(Component.m_237115_((String)"custommachinery.jei.ingredient.fluid.pertick"));
                }
                if (this.chance == 0.0) {
                    tooltips.add(Component.m_237115_((String)"custommachinery.jei.ingredient.chance.0").m_130940_(ChatFormatting.DARK_RED));
                } else if (this.chance != 1.0) {
                    tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{(int)(this.chance * 100.0)}));
                }
                if (!this.tank.isEmpty() && Minecraft.m_91087_().f_91066_.f_92125_) {
                    tooltips.add(Component.m_237115_((String)"custommachinery.jei.ingredient.fluid.specificTank").m_130940_(ChatFormatting.DARK_RED));
                }
            });
            return true;
        }
        return false;
    }
}

