/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.render.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import fr.frinn.custommachinerymekanism.client.ClientHandler;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import fr.frinn.custommachinerymekanism.common.guielement.ChemicalGuiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ChemicalGuiElementWidget<C extends ChemicalMachineComponent<?, ?>, E extends ChemicalGuiElement<C>>
extends TexturedGuiElementWidget<E> {
    public ChemicalGuiElementWidget(E element, IMachineScreen screen, Component title) {
        super(element, screen, title);
    }

    public abstract MachineComponentType<C> componentType();

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponentHandler(this.componentType()).flatMap(gasHandler -> gasHandler.getComponentForID(((ChemicalGuiElement)this.getElement()).getID())).ifPresent(component -> {
            Object stack = component.getStack();
            if (!stack.isEmpty()) {
                RenderSystem.m_69478_();
                int desiredHeight = MathUtils.clampToInt((double)((double)(this.f_93619_ - 2) * (double)stack.getAmount() / (double)component.getCapacity()));
                if (desiredHeight < 1) {
                    desiredHeight = 1;
                }
                if (desiredHeight > this.f_93619_) {
                    desiredHeight = this.f_93619_;
                }
                Chemical chemical = stack.getType();
                MekanismRenderer.color((Chemical)chemical);
                GuiUtils.drawTiledSprite((PoseStack)poseStack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)(this.f_93619_ - 2), (int)(this.f_93618_ - 2), (int)desiredHeight, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT, (boolean)false);
                MekanismRenderer.resetColor();
                RenderSystem.m_69461_();
            }
        });
        if (this.m_198029_() && ((ChemicalGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight(poseStack, this.f_93620_ + 1, this.f_93621_ + 1, this.f_93618_ - 2, this.f_93619_ - 2);
        }
    }

    public List<Component> getTooltips() {
        return this.getScreen().getTile().getComponentManager().getComponentHandler(this.componentType()).flatMap(gasHandler -> gasHandler.getComponentForID(((ChemicalGuiElement)this.getElement()).getID())).map(component -> {
            Object stack = component.getStack();
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(TextComponentUtil.build((Object[])new Object[]{stack}));
            tooltips.add(MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, new Object[]{TextUtils.format((long)stack.getAmount())}));
            ChemicalUtil.addChemicalDataToTooltip(tooltips, (Chemical)stack.getType(), (boolean)false);
            return tooltips;
        }).orElse(Collections.emptyList());
    }
}

