/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.render.element;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.ClientHandler;
import fr.frinn.custommachinerymekanism.common.guielement.HeatGuiElement;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.api.IIncrementalEnum;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class HeatGuiElementWidget
extends TexturedGuiElementWidget<HeatGuiElement> {
    public HeatGuiElementWidget(HeatGuiElement element, IMachineScreen screen) {
        super((AbstractTexturedGuiElement)element, screen, (Component)Component.m_237113_((String)"Heat"));
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(pose, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).ifPresent(component -> {
            double fillPercent = component.getHeatFillPercent();
            int barHeight = Mth.m_14045_((int)((int)(fillPercent * (double)this.f_93619_)), (int)1, (int)(this.f_93619_ - 1));
            GuiComponent.m_93172_((PoseStack)pose, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + this.f_93619_ - barHeight), (int)(this.f_93620_ + this.f_93618_ - 1), (int)(this.f_93621_ + this.f_93619_ - 1), (int)FastColor.ARGB32.m_13660_((int)200, (int)255, (int)128, (int)0));
        });
        if (this.m_198029_() && ((HeatGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight(pose, this.f_93620_ + 1, this.f_93621_ + 1, this.f_93618_ - 2, this.f_93619_ - 2);
        }
    }

    public List<Component> getTooltips() {
        return this.getScreen().getTile().getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).map(component -> List.of(MekanismLang.TEMPERATURE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)component.getTemperature(0), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), MekanismLang.DISSIPATED_RATE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)component.getLastEnvironmentalLoss(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false)}), MekanismLang.UNIT.translate(new Object[]{MekanismConfig.common.tempUnit.get()}))).orElse(Collections.emptyList());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_198029_()) {
            return false;
        }
        if (button == 0) {
            this.updateTemperatureUnit(IIncrementalEnum::getNext);
        } else if (button == 1) {
            this.updateTemperatureUnit(IIncrementalEnum::getPrevious);
        }
        return true;
    }

    private void updateTemperatureUnit(UnaryOperator<UnitDisplayUtils.TemperatureUnit> converter) {
        UnitDisplayUtils.TemperatureUnit updated;
        UnitDisplayUtils.TemperatureUnit current = (UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get();
        if (current != (updated = (UnitDisplayUtils.TemperatureUnit)converter.apply(current))) {
            MekanismConfig.common.tempUnit.set((Object)updated);
            MekanismConfig.common.save();
        }
    }
}

