/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function9;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinerymekanism.common.network.syncable.ChemicalStackSyncable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ChemicalMachineComponent<C extends Chemical<C>, S extends ChemicalStack<C>>
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent {
    private final String id;
    private final long capacity;
    private final List<C> filter;
    private final boolean whitelist;
    private final long maxInput;
    private final long maxOutput;
    private final SideConfig config;
    private final boolean unique;
    private S stack = this.empty();

    public ChemicalMachineComponent(IMachineComponentManager manager, String id, long capacity, ComponentIOMode mode, List<C> filter, boolean whitelist, long maxInput, long maxOutput, SideConfig.Template config, boolean unique) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.filter = filter;
        this.whitelist = whitelist;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.config = config.build((ISideConfigComponent)this);
        this.unique = unique;
    }

    public abstract S empty();

    public abstract S createStack(C var1, long var2);

    public abstract S readFromNBT(CompoundTag var1);

    public S createStack(S stack, long amount) {
        return (S)this.createStack((S)stack.getType(), amount);
    }

    public String getId() {
        return this.id;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public S getStack() {
        return this.stack;
    }

    public void setStack(S stack) {
        this.stack = stack;
        this.getManager().markDirty();
    }

    public boolean isValid(S stack) {
        if (this.unique && this.stack.isEmpty() && this.getManager().getComponentHandler(this.getType()).stream().flatMap(handler -> handler.getComponents().stream()).anyMatch(component -> {
            if (component == this) return false;
            if (!(component instanceof ChemicalMachineComponent)) return false;
            ChemicalMachineComponent chemical = (ChemicalMachineComponent)((Object)component);
            if (stack.getType() != chemical.stack.getType()) return false;
            return true;
        })) {
            return false;
        }
        if (this.filter.stream().anyMatch(gas -> gas == stack.getType()) != this.whitelist) {
            return false;
        }
        return this.stack.isEmpty() || this.stack.isTypeEqual(stack);
    }

    public S insert(S stack, Action action, boolean byPassLimit) {
        long maxInsert;
        if (!this.isValid(stack)) {
            return stack;
        }
        if (!this.stack.isEmpty() && this.stack.getType() != stack.getType()) {
            return stack;
        }
        long l = maxInsert = this.stack.isEmpty() ? Math.min(this.capacity, stack.getAmount()) : Math.min(this.capacity - this.stack.getAmount(), stack.getAmount());
        if (!byPassLimit) {
            maxInsert = Math.min(maxInsert, this.maxInput);
        }
        if (action.execute()) {
            this.setStack(this.createStack(stack, maxInsert + (this.stack.isEmpty() ? 0L : this.stack.getAmount())));
        }
        return this.createStack(stack, stack.getAmount() - maxInsert);
    }

    public S extract(long amount, Action action, boolean byPassLimit) {
        if (this.stack.isEmpty()) {
            return this.empty();
        }
        long maxExtract = Math.min(this.stack.getAmount(), amount);
        if (!byPassLimit) {
            maxExtract = Math.min(maxExtract, this.maxOutput);
        }
        Chemical type = this.stack.getType();
        if (action.execute()) {
            this.stack.shrink(maxExtract);
            this.getManager().markDirty();
        }
        return (S)this.createStack((S)type, maxExtract);
    }

    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.stack.getAmount() / (double)this.capacity));
    }

    public void serialize(CompoundTag nbt) {
        if (!this.stack.isEmpty()) {
            nbt.m_128365_("stack", (Tag)this.stack.write(new CompoundTag()));
        }
        nbt.m_128365_("config", this.config.serialize());
    }

    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128441_("stack")) {
            this.stack = this.readFromNBT(nbt.m_128469_("stack"));
        }
        if (nbt.m_128441_("config")) {
            this.config.deserialize(nbt.m_128423_("config"));
        }
    }

    public SideConfig getConfig() {
        return this.config;
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept((ISyncable<?, ?>)ChemicalStackSyncable.create(this::getStack, this::setStack));
        container.accept(DataType.createSyncable(SideConfig.class, this::getConfig, arg_0 -> ((SideConfig)this.config).set(arg_0)));
    }

    public static abstract class Template<C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalMachineComponent<C, S>>
    implements IMachineComponentTemplate<T> {
        private final String id;
        private final long capacity;
        private final ComponentIOMode mode;
        private final List<C> filter;
        private final boolean whitelist;
        private final long maxInput;
        private final long maxOutput;
        private final SideConfig.Template config;
        private final boolean unique;

        public static <C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalMachineComponent<C, S>> NamedCodec<Template<C, S, T>> makeCodec(NamedCodec<C> codec, Function9<String, Long, ComponentIOMode, List<C>, Boolean, Long, Long, SideConfig.Template, Boolean, Template<C, S, T>> builder) {
            return NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), (App)NamedCodec.LONG.fieldOf("capacity").forGetter(template -> template.capacity), (App)ComponentIOMode.CODEC.optionalFieldOf("mode", (Object)ComponentIOMode.BOTH).forGetter(template -> template.mode), (App)codec.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(template -> template.filter), (App)NamedCodec.BOOL.optionalFieldOf("whitelist", (Object)false).forGetter(template -> template.whitelist), (App)NamedCodec.LONG.optionalFieldOf("max_input").forGetter(template -> Optional.of(template.maxInput)), (App)NamedCodec.LONG.optionalFieldOf("max_output").forGetter(template -> Optional.of(template.maxOutput)), (App)SideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> Optional.of(template.config)), (App)NamedCodec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(template -> template.unique)).apply((Applicative)templateInstance, (id, capacity, mode, filter, whitelist, maxInput, maxOutput, config, unique) -> (Template)builder.apply(id, capacity, mode, filter, whitelist, (Object)maxInput.orElse(capacity), (Object)maxOutput.orElse(capacity), (Object)config.orElse(mode.getBaseConfig()), unique)), (String)(codec.name() + " machine component"));
        }

        public Template(String id, long capacity, ComponentIOMode mode, List<C> filter, boolean whitelist, long maxInput, long maxOutput, SideConfig.Template config, boolean unique) {
            this.id = id;
            this.capacity = capacity;
            this.mode = mode;
            this.filter = filter;
            this.whitelist = whitelist;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.config = config;
            this.unique = unique;
        }

        public abstract boolean isSameType(ChemicalStack<?> var1);

        public String getId() {
            return this.id;
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            ChemicalStack stack;
            if (isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof ChemicalStack && this.isSameType(stack = (ChemicalStack)ingredient)) {
                return this.filter.stream().anyMatch(g -> g == stack.getType()) == this.whitelist;
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    ChemicalStack stack;
                    if (object instanceof ChemicalStack && this.isSameType(stack = (ChemicalStack)object)) {
                        return this.filter.stream().anyMatch(g -> g == stack.getType()) == this.whitelist;
                    }
                    return false;
                });
            }
            return false;
        }

        public abstract T build(IMachineComponentManager var1, String var2, long var3, ComponentIOMode var5, List<C> var6, boolean var7, long var8, long var10, SideConfig.Template var12, boolean var13);

        public T build(IMachineComponentManager manager) {
            return this.build(manager, this.id, this.capacity, this.mode, this.filter, this.whitelist, this.maxInput, this.maxOutput, this.config, this.unique);
        }
    }
}

