/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import fr.frinn.custommachinerymekanism.common.utils.Codecs;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import net.minecraft.nbt.CompoundTag;

public class GasMachineComponent
extends ChemicalMachineComponent<Gas, GasStack> {
    public GasMachineComponent(IMachineComponentManager manager, String id, long capacity, ComponentIOMode mode, List<Gas> filter, boolean whitelist, long maxInput, long maxOutput, SideConfig.Template config, boolean unique) {
        super(manager, id, capacity, mode, filter, whitelist, maxInput, maxOutput, config, unique);
    }

    public MachineComponentType<GasMachineComponent> getType() {
        return (MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get();
    }

    @Override
    public GasStack empty() {
        return GasStack.EMPTY;
    }

    @Override
    public GasStack createStack(Gas type, long amount) {
        return new GasStack((IGasProvider)type, amount);
    }

    @Override
    public GasStack readFromNBT(CompoundTag nbt) {
        return GasStack.readFromNBT((CompoundTag)nbt);
    }

    public static class Template
    extends ChemicalMachineComponent.Template<Gas, GasStack, GasMachineComponent> {
        public static final NamedCodec<ChemicalMachineComponent.Template<Gas, GasStack, GasMachineComponent>> CODEC = Template.makeCodec(Codecs.GAS, Template::new);

        public Template(String id, long capacity, ComponentIOMode mode, List<Gas> filter, boolean whitelist, long maxInput, long maxOutput, SideConfig.Template config, boolean unique) {
            super(id, capacity, mode, filter, whitelist, maxInput, maxOutput, config, unique);
        }

        @Override
        public boolean isSameType(ChemicalStack<?> stack) {
            return stack instanceof GasStack;
        }

        public MachineComponentType<GasMachineComponent> getType() {
            return (MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get();
        }

        @Override
        public GasMachineComponent build(IMachineComponentManager manager, String id, long capacity, ComponentIOMode mode, List<Gas> filter, boolean whitelist, long maxInput, long maxOutput, SideConfig.Template config, boolean unique) {
            return new GasMachineComponent(manager, id, capacity, mode, filter, whitelist, maxInput, maxOutput, config, unique);
        }
    }
}

