/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import fr.frinn.custommachinerymekanism.Registration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.IContentsListener;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class HeatMachineComponent
extends AbstractMachineComponent
implements ISideConfigComponent,
ITileHeatHandler,
ISerializableComponent,
ISyncableStuff,
ITickableComponent,
IDumpComponent {
    private final double baseTemp;
    private final SideConfig config;
    private final BasicHeatCapacitor capacitor;
    private final Map<Direction, LazyOptional<IHeatHandler>> neighbours = Maps.newEnumMap(Direction.class);
    private LazyOptional<IHeatHandler> handler;
    private double lastEnvironmentalLoss;

    public HeatMachineComponent(IMachineComponentManager manager, double capacity, double baseTemp, double inverseConductionCoefficient, double inverseInsulationCoefficient, SideConfig.Template config) {
        super(manager, ComponentIOMode.BOTH);
        this.baseTemp = baseTemp;
        this.config = config.build((ISideConfigComponent)this);
        this.config.setCallback(this::onConfigChange);
        this.capacitor = BasicHeatCapacitor.create((double)capacity, (double)inverseConductionCoefficient, (double)inverseInsulationCoefficient, () -> baseTemp, (IContentsListener)this);
        this.handler = LazyOptional.of(() -> this);
    }

    public MachineComponentType<HeatMachineComponent> getType() {
        return (MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public SideConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return "Heat";
    }

    public void serverTick() {
        this.capacitor.update();
        this.updateNeighbours();
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.lastEnvironmentalLoss = transfer.environmentTransfer();
    }

    public void dump(List<String> ids) {
        this.capacitor.setHeat(this.baseTemp);
    }

    public double getLastEnvironmentalLoss() {
        return this.lastEnvironmentalLoss;
    }

    public double getHeatFillPercent() {
        return (this.capacitor.getTemperature() - this.baseTemp) / this.capacitor.getHeatCapacity();
    }

    private void onConfigChange(RelativeSide side, SideMode old, SideMode now) {
        this.handler.invalidate();
        this.handler = LazyOptional.of(() -> this);
        if (old.isNone()) {
            this.getManager().getLevel().m_46672_(this.getManager().getTile().m_58899_(), this.getManager().getTile().m_58900_().m_60734_());
        }
    }

    private void updateNeighbours() {
        Level level = this.getManager().getLevel();
        BlockPos pos = this.getManager().getTile().m_58899_();
        for (Direction side : Direction.values()) {
            BlockEntity be;
            LazyOptional<IHeatHandler> handler = this.neighbours.get(side);
            if (handler == null) {
                this.neighbours.put(side, (LazyOptional<IHeatHandler>)LazyOptional.empty());
                continue;
            }
            if (handler.isPresent() || (be = level.m_7702_(pos.m_121945_(side))) == null) continue;
            this.neighbours.put(side, (LazyOptional<IHeatHandler>)be.getCapability(Capabilities.HEAT_HANDLER, side.m_122424_()));
        }
    }

    public LazyOptional<IHeatHandler> getHeatHandler(@Nullable Direction side) {
        if (!this.config.getSideMode(side).isNone()) {
            return this.handler;
        }
        return LazyOptional.empty();
    }

    public void serialize(CompoundTag nbt) {
        nbt.m_128347_("Heat", this.capacitor.getHeat());
    }

    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128425_("Heat", 6)) {
            this.capacitor.setHeat(nbt.m_128459_("Heat"));
        }
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(DataType.createSyncable(SideConfig.class, this::getConfig, arg_0 -> ((SideConfig)this.config).set(arg_0)));
        container.accept(DataType.createSyncable(Double.class, () -> ((BasicHeatCapacitor)this.capacitor).getHeat(), arg_0 -> ((BasicHeatCapacitor)this.capacitor).setHeat(arg_0)));
        container.accept(DataType.createSyncable(Double.class, this::getLastEnvironmentalLoss, loss -> {
            this.lastEnvironmentalLoss = loss;
        }));
    }

    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction direction) {
        return Collections.singletonList(this.capacitor);
    }

    public void onContentsChanged() {
        this.getManager().markDirty();
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        return (IHeatHandler)this.neighbours.get(side).orElse(null);
    }

    public static class Template
    implements IMachineComponentTemplate<HeatMachineComponent> {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.DOUBLE.optionalFieldOf("capacity", (Object)373.0).forGetter(template -> template.capacity), (App)NamedCodec.DOUBLE.optionalFieldOf("base_temp", (Object)300.0).forGetter(template -> template.baseTemp), (App)NamedCodec.DOUBLE.optionalFieldOf("conduction", (Object)1.0).forGetter(template -> template.inverseConductionCoefficient), (App)NamedCodec.DOUBLE.optionalFieldOf("insulation", (Object)0.0).forGetter(template -> template.inverseInsulationCoefficient), (App)SideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> Optional.of(template.config))).apply((Applicative)templateInstance, (capacity, baseTemp, conduction, insulation, config) -> new Template((double)capacity, (double)baseTemp, (double)conduction, (double)insulation, config.orElse(ComponentIOMode.INPUT.getBaseConfig()))), (String)"Heat machine component");
        private final double capacity;
        private final double baseTemp;
        private final double inverseConductionCoefficient;
        private final double inverseInsulationCoefficient;
        private final SideConfig.Template config;

        public Template(double capacity, double baseTemp, double inverseConductionCoefficient, double inverseInsulationCoefficient, SideConfig.Template config) {
            this.capacity = capacity;
            this.baseTemp = baseTemp;
            this.inverseConductionCoefficient = inverseConductionCoefficient;
            this.inverseInsulationCoefficient = inverseInsulationCoefficient;
            this.config = config;
        }

        public MachineComponentType<HeatMachineComponent> getType() {
            return (MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get();
        }

        public String getId() {
            return "Heat";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return true;
        }

        public HeatMachineComponent build(IMachineComponentManager manager) {
            return new HeatMachineComponent(manager, this.capacity, this.baseTemp, this.inverseConductionCoefficient, this.inverseInsulationCoefficient, this.config);
        }
    }
}

