/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import com.google.common.base.Suppliers;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinerymekanism.Registration;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.radiation.IRadiationSource;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RadiationMachineComponent
extends AbstractMachineComponent {
    private final Supplier<Coord4D> coords = Suppliers.memoize(() -> new Coord4D((BlockEntity)manager.getTile()));

    public RadiationMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public double getRadiations() {
        return MekanismAPI.getRadiationManager().getRadiationLevel(this.coords.get());
    }

    public void removeRadiations(double amount, int radius) {
        Set checkChunks = new Chunk3D(this.coords.get()).expand((int)Math.ceil((double)radius / 16.0));
        for (Chunk3D chunk : checkChunks) {
            for (Map.Entry entry : MekanismAPI.getRadiationManager().getRadiationSources().row((Object)chunk).entrySet()) {
                if (!(((Coord4D)entry.getKey()).distanceTo(this.coords.get()) <= (double)radius)) continue;
                IRadiationSource source = (IRadiationSource)entry.getValue();
                double toRemove = Math.min(source.getMagnitude(), amount);
                source.radiate(-toRemove);
                if (!((amount -= toRemove) <= 0.0)) continue;
                return;
            }
        }
    }

    public void addRadiations(double amount) {
        MekanismAPI.getRadiationManager().radiate(this.coords.get(), amount);
    }

    public MachineComponentType<RadiationMachineComponent> getType() {
        return (MachineComponentType)Registration.RADIATION_MACHINE_COMPONENT.get();
    }
}

