/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component.handler;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChemicalComponentHandler<C extends Chemical<C>, S extends ChemicalStack<C>, H extends IChemicalHandler<C, S>, T extends ChemicalMachineComponent<C, S>>
extends AbstractComponentHandler<T>
implements ISerializableComponent,
ISyncableStuff,
ITickableComponent,
IDumpComponent {
    private final H generalHandler = this.createSidedHandler(null);
    private final LazyOptional<H> generalHandlerCap = LazyOptional.of(() -> this.generalHandler);
    private final Map<Direction, LazyOptional<H>> sidedHandlers = Maps.newEnumMap(Direction.class);
    private final List<T> inputs;
    private final List<T> outputs;
    private final Map<String, T> idMap;
    private final Map<Direction, LazyOptional<H>> neighbourStorages = Maps.newEnumMap(Direction.class);

    public ChemicalComponentHandler(IMachineComponentManager manager, List<T> components) {
        super(manager, components);
        Arrays.stream(Direction.values()).forEach(side -> this.sidedHandlers.put((Direction)side, (LazyOptional<H>)LazyOptional.of(() -> this.createSidedHandler((Direction)side))));
        this.inputs = components.stream().filter(component -> component.getMode().isInput()).toList();
        this.outputs = components.stream().filter(component -> component.getMode().isOutput()).toList();
        this.idMap = components.stream().collect(Collectors.toMap(ChemicalMachineComponent::getId, Function.identity()));
    }

    public abstract Capability<H> targetCap();

    public abstract H createSidedHandler(@Nullable Direction var1);

    @NotNull
    public LazyOptional<H> getSidedHandler(@Nullable Direction side) {
        if (side == null) {
            return this.generalHandlerCap;
        }
        return this.sidedHandlers.get(side);
    }

    public H getGeneralHandler() {
        return this.generalHandler;
    }

    public Optional<T> getComponentForID(String id) {
        return Optional.ofNullable((ChemicalMachineComponent)((Object)this.idMap.get(id)));
    }

    public ComponentIOMode getMode() {
        return ComponentIOMode.NONE;
    }

    public void serialize(CompoundTag nbt) {
        ListTag componentsNBT = new ListTag();
        this.getComponents().forEach(component -> {
            CompoundTag componentNBT = new CompoundTag();
            component.serialize(componentNBT);
            componentNBT.m_128359_("id", component.getId());
            componentsNBT.add((Object)componentNBT);
        });
        nbt.m_128365_("gases", (Tag)componentsNBT);
    }

    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128425_("fluids", 9)) {
            ListTag componentsNBT = nbt.m_128437_("gases", 10);
            componentsNBT.forEach(inbt -> {
                CompoundTag componentNBT;
                if (inbt instanceof CompoundTag && (componentNBT = (CompoundTag)inbt).m_128425_("id", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.m_128461_("id"))).findFirst().ifPresent(component -> component.deserialize(componentNBT));
                }
            });
        }
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> consumer) {
        this.getComponents().forEach(component -> component.getStuffToSync(consumer));
    }

    public void serverTick() {
        for (Direction side : Direction.values()) {
            LazyOptional neighbour;
            if (this.getComponents().stream().allMatch(component -> component.getConfig().getSideMode(side) == SideMode.NONE)) continue;
            if (this.neighbourStorages.get(side) == null) {
                neighbour = Optional.ofNullable(this.getManager().getLevel().m_7702_(this.getManager().getTile().m_58899_().m_121945_(side))).map(tile -> tile.getCapability(this.targetCap(), side.m_122424_())).orElse(LazyOptional.empty());
                neighbour.ifPresent(storage -> {
                    neighbour.addListener(cap -> this.neighbourStorages.remove(side));
                    this.neighbourStorages.put(side, neighbour);
                });
            } else {
                neighbour = this.neighbourStorages.get(side);
            }
            neighbour.ifPresent(storage -> {
                for (ChemicalMachineComponent component : this.getComponents()) {
                    ChemicalStack remaining;
                    Object maxExtract;
                    if (component.getConfig().isAutoInput() && component.getConfig().getSideMode(side).isInput() && component.getStack().getAmount() < component.getCapacity()) {
                        maxExtract = storage.extractChemical(Long.MAX_VALUE, Action.SIMULATE);
                        if (maxExtract.isEmpty() || (remaining = component.insert(maxExtract, Action.SIMULATE, false)).getAmount() >= maxExtract.getAmount()) continue;
                        component.insert(storage.extractChemical(Long.MAX_VALUE, Action.EXECUTE), Action.EXECUTE, false);
                    }
                    if (!component.getConfig().isAutoOutput() || !component.getConfig().getSideMode(side).isOutput() || component.getStack().getAmount() <= 0L || (maxExtract = component.extract(Long.MAX_VALUE, Action.SIMULATE, false)).isEmpty() || (remaining = storage.insertChemical(maxExtract, Action.SIMULATE)).getAmount() >= maxExtract.getAmount() && !remaining.isEmpty()) continue;
                    storage.insertChemical(component.extract(Long.MAX_VALUE, Action.EXECUTE, false), Action.EXECUTE);
                }
            });
        }
    }

    public void dump(List<String> ids) {
        this.getComponents().stream().filter(component -> ids.contains(component.getId())).forEach(component -> component.setStack(component.empty()));
    }

    public long getChemicalAmount(String tank, C chemical) {
        Predicate<ChemicalMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.inputs.stream().filter(component -> component.getStack().getType() == chemical && tankPredicate.test((ChemicalMachineComponent)((Object)component))).mapToLong(component -> component.getStack().getAmount()).sum();
    }

    public long getSpaceForChemical(String tank, C chemical) {
        Predicate<ChemicalMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.outputs.stream().filter(component -> component.isValid(component.createStack(chemical, 1L)) && tankPredicate.test((ChemicalMachineComponent)((Object)component))).mapToLong(component -> component.getCapacity() - component.insert(component.createStack(chemical, component.getCapacity()), Action.SIMULATE, true).getAmount()).sum();
    }

    public void removeFromInputs(String tank, C chemical, long amount) {
        AtomicLong toRemove = new AtomicLong(amount);
        Predicate<ChemicalMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.inputs.stream().filter(component -> component.getStack().getType() == chemical && tankPredicate.test((ChemicalMachineComponent)((Object)component))).forEach(component -> {
            long maxExtract = Math.min(component.getStack().getAmount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.extract(maxExtract, Action.EXECUTE, true);
        });
    }

    public void addToOutputs(String tank, C chemical, long amount) {
        AtomicLong toAdd = new AtomicLong(amount);
        Predicate<ChemicalMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.outputs.stream().filter(component -> component.isValid(component.createStack(chemical, 1L)) && tankPredicate.test((ChemicalMachineComponent)((Object)component))).sorted(Comparator.comparingInt(component -> component.getStack().getType() == chemical ? -1 : 1)).forEach(component -> {
            long maxInsert = toAdd.get() - component.insert(component.createStack(chemical, toAdd.get()), Action.EXECUTE, true).getAmount();
            toAdd.addAndGet(-maxInsert);
        });
    }
}

