/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.integration.crafttweaker.machine;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomMachineRecipeCTBuilder;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinerymekanism.common.requirement.HeatPerTickRequirement;
import fr.frinn.custommachinerymekanism.common.requirement.HeatRequirement;
import fr.frinn.custommachinerymekanism.common.requirement.TemperatureRequirement;
import java.util.Locale;
import mekanism.common.util.UnitDisplayUtils;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Expansion(value="mods.custommachinery.CMRecipeBuilder")
public class HeatRequirementCT {
    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireHeat(CustomMachineRecipeCTBuilder builder, double amount) {
        return builder.addRequirement((IRequirement)new HeatRequirement(RequirementIOMode.INPUT, amount));
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireHeatPerTick(CustomMachineRecipeCTBuilder builder, double amount) {
        return builder.addRequirement((IRequirement)new HeatPerTickRequirement(RequirementIOMode.INPUT, amount));
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder produceHeat(CustomMachineRecipeCTBuilder builder, double amount) {
        return builder.addRequirement((IRequirement)new HeatRequirement(RequirementIOMode.OUTPUT, amount));
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder produceHeatPerTick(CustomMachineRecipeCTBuilder builder, double amount) {
        return builder.addRequirement((IRequirement)new HeatPerTickRequirement(RequirementIOMode.OUTPUT, amount));
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTemp(CustomMachineRecipeCTBuilder builder, String range, String unit) {
        try {
            IntRange temp = IntRange.createFromString((String)range);
            try {
                UnitDisplayUtils.TemperatureUnit temperatureUnit = UnitDisplayUtils.TemperatureUnit.valueOf((String)unit.toUpperCase(Locale.ROOT));
                return builder.addRequirement((IRequirement)new TemperatureRequirement(temp, temperatureUnit));
            }
            catch (IllegalArgumentException e) {
                return builder.error("Invalid temperature unit: {}\n{}", new Object[]{unit, e.getMessage()});
            }
        }
        catch (IllegalArgumentException e) {
            return builder.error("Invalid temperature range: {}\n{}", new Object[]{range, e.getMessage()});
        }
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTempCelsius(CustomMachineRecipeCTBuilder builder, String range) {
        return HeatRequirementCT.requireTemp(builder, range, UnitDisplayUtils.TemperatureUnit.CELSIUS.name());
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTempFahrenheit(CustomMachineRecipeCTBuilder builder, String range) {
        return HeatRequirementCT.requireTemp(builder, range, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT.name());
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTempKelvin(CustomMachineRecipeCTBuilder builder, String range) {
        return HeatRequirementCT.requireTemp(builder, range, UnitDisplayUtils.TemperatureUnit.KELVIN.name());
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTempRankine(CustomMachineRecipeCTBuilder builder, String range) {
        return HeatRequirementCT.requireTemp(builder, range, UnitDisplayUtils.TemperatureUnit.RANKINE.name());
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder requireTempAmbient(CustomMachineRecipeCTBuilder builder, String range) {
        return HeatRequirementCT.requireTemp(builder, range, UnitDisplayUtils.TemperatureUnit.AMBIENT.name());
    }
}

