/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.mixin;

import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.integration.crafttweaker.function.MachineCT;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import fr.frinn.custommachinerymekanism.common.component.RadiationMachineComponent;
import fr.frinn.custommachinerymekanism.common.component.handler.GasComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.InfusionComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.PigmentComponentHandler;
import fr.frinn.custommachinerymekanism.common.component.handler.SlurryComponentHandler;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import org.openzen.zencode.java.ZenCodeType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MachineCT.class}, remap=false)
public class MachineCTMixin {
    @Final
    @Shadow(remap=false)
    private CustomMachineTile internal;

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTGasStack getGasStored(String tank) {
        return (ICrTChemicalStack.ICrTGasStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTGasStack(((GasStack)component.getStack()).copy())).orElse(new CrTChemicalStack.CrTGasStack(GasStack.EMPTY));
    }

    @ZenCodeType.Method
    public void setGasStored(String tank, ICrTChemicalStack.ICrTGasStack stack) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(component -> component.setStack((GasStack)stack.getInternal()));
    }

    @ZenCodeType.Method
    public long getGasCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(ChemicalMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTGasStack addGas(ICrTChemicalStack.ICrTGasStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTGasStack((GasStack)((IGasHandler)((GasComponentHandler)((Object)handler)).getGeneralHandler()).insertChemical((ChemicalStack)((GasStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTGasStack addGasToTank(String tank, ICrTChemicalStack.ICrTGasStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTGasStack(component.insert((GasStack)stack.getInternal(), simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTGasStack removeGas(ICrTChemicalStack.ICrTGasStack stack, boolean simulate) {
        return (ICrTChemicalStack.ICrTGasStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTGasStack((GasStack)((IGasHandler)((GasComponentHandler)((Object)handler)).getGeneralHandler()).extractChemical((ChemicalStack)((GasStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse(new CrTChemicalStack.CrTGasStack(GasStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTGasStack removeGasFromTank(String tank, long amount, boolean simulate) {
        return (ICrTChemicalStack.ICrTGasStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTGasStack((GasStack)component.extract(amount, simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse(new CrTChemicalStack.CrTGasStack(GasStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTInfusionStack getInfusionStored(String tank) {
        return (ICrTChemicalStack.ICrTInfusionStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTInfusionStack(((InfusionStack)component.getStack()).copy())).orElse(new CrTChemicalStack.CrTInfusionStack(InfusionStack.EMPTY));
    }

    @ZenCodeType.Method
    public void setInfusionStored(String tank, ICrTChemicalStack.ICrTInfusionStack stack) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(component -> component.setStack((InfusionStack)stack.getInternal()));
    }

    @ZenCodeType.Method
    public long getInfusionCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(ChemicalMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTInfusionStack addInfusion(ICrTChemicalStack.ICrTInfusionStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTInfusionStack((InfusionStack)((IInfusionHandler)((InfusionComponentHandler)((Object)handler)).getGeneralHandler()).insertChemical((ChemicalStack)((InfusionStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTInfusionStack addInfusionToTank(String tank, ICrTChemicalStack.ICrTInfusionStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTInfusionStack(component.insert((InfusionStack)stack.getInternal(), simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTInfusionStack removeInfusion(ICrTChemicalStack.ICrTInfusionStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTInfusionStack((InfusionStack)((IInfusionHandler)((InfusionComponentHandler)((Object)handler)).getGeneralHandler()).extractChemical((ChemicalStack)((InfusionStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse((ICrTChemicalStack.ICrTInfusionStack)new CrTChemicalStack.CrTInfusionStack(InfusionStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTInfusionStack removeInfusionFromTank(String tank, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTInfusionStack((InfusionStack)component.extract(amount, simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse((ICrTChemicalStack.ICrTInfusionStack)new CrTChemicalStack.CrTInfusionStack(InfusionStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTPigmentStack getPigmentStored(String tank) {
        return (ICrTChemicalStack.ICrTPigmentStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTPigmentStack(((PigmentStack)component.getStack()).copy())).orElse(new CrTChemicalStack.CrTPigmentStack(PigmentStack.EMPTY));
    }

    @ZenCodeType.Method
    public void setPigmentStored(String tank, ICrTChemicalStack.ICrTPigmentStack stack) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(component -> component.setStack((PigmentStack)stack.getInternal()));
    }

    @ZenCodeType.Method
    public long getPigmentCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(ChemicalMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTPigmentStack addPigment(ICrTChemicalStack.ICrTPigmentStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTPigmentStack((PigmentStack)((IPigmentHandler)((PigmentComponentHandler)((Object)handler)).getGeneralHandler()).insertChemical((ChemicalStack)((PigmentStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTPigmentStack addPigmentToTank(String tank, ICrTChemicalStack.ICrTPigmentStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTPigmentStack(component.insert((PigmentStack)stack.getInternal(), simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTPigmentStack removePigment(ICrTChemicalStack.ICrTPigmentStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTPigmentStack((PigmentStack)((IPigmentHandler)((PigmentComponentHandler)((Object)handler)).getGeneralHandler()).extractChemical((ChemicalStack)((PigmentStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse((ICrTChemicalStack.ICrTPigmentStack)new CrTChemicalStack.CrTPigmentStack(PigmentStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTPigmentStack removePigmentFromTank(String tank, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.PIGMENT_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTPigmentStack((PigmentStack)component.extract(amount, simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse((ICrTChemicalStack.ICrTPigmentStack)new CrTChemicalStack.CrTPigmentStack(PigmentStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTSlurryStack getSlurryStored(String tank) {
        return (ICrTChemicalStack.ICrTSlurryStack)this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTSlurryStack(((SlurryStack)component.getStack()).copy())).orElse(new CrTChemicalStack.CrTSlurryStack(SlurryStack.EMPTY));
    }

    @ZenCodeType.Method
    public void setSlurryStored(String tank, ICrTChemicalStack.ICrTSlurryStack stack) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(component -> component.setStack((SlurryStack)stack.getInternal()));
    }

    @ZenCodeType.Method
    public long getSlurryCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(ChemicalMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTSlurryStack addSlurry(ICrTChemicalStack.ICrTSlurryStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTSlurryStack((SlurryStack)((ISlurryHandler)((SlurryComponentHandler)((Object)handler)).getGeneralHandler()).insertChemical((ChemicalStack)((SlurryStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTSlurryStack addSlurryToTank(String tank, ICrTChemicalStack.ICrTSlurryStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTSlurryStack(component.insert((SlurryStack)stack.getInternal(), simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse(stack);
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTSlurryStack removeSlurry(ICrTChemicalStack.ICrTSlurryStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).map(handler -> new CrTChemicalStack.CrTSlurryStack((SlurryStack)((ISlurryHandler)((SlurryComponentHandler)((Object)handler)).getGeneralHandler()).extractChemical((ChemicalStack)((SlurryStack)stack.getInternal()), simulate ? Action.SIMULATE : Action.EXECUTE))).orElse((ICrTChemicalStack.ICrTSlurryStack)new CrTChemicalStack.CrTSlurryStack(SlurryStack.EMPTY));
    }

    @ZenCodeType.Method
    public ICrTChemicalStack.ICrTSlurryStack removeSlurryFromTank(String tank, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> new CrTChemicalStack.CrTSlurryStack((SlurryStack)component.extract(amount, simulate ? Action.SIMULATE : Action.EXECUTE, true))).orElse((ICrTChemicalStack.ICrTSlurryStack)new CrTChemicalStack.CrTSlurryStack(SlurryStack.EMPTY));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="heat")
    public double getHeat() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).flatMap(component -> Optional.ofNullable(component.getHeatCapacitor(0, null))).map(IHeatCapacitor::getHeat).orElse(0.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="temperature")
    public double getTemperature() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).flatMap(component -> Optional.ofNullable(component.getHeatCapacitor(0, null))).map(IHeatCapacitor::getTemperature).orElse(0.0);
    }

    @ZenCodeType.Method
    public void addHeat(double heat) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).flatMap(component -> Optional.ofNullable(component.getHeatCapacitor(0, null))).ifPresent(capacitor -> capacitor.handleHeat(heat));
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="heat")
    public void setHeat(double heat) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get()).flatMap(component -> Optional.ofNullable(component.getHeatCapacitor(0, null))).ifPresent(capacitor -> capacitor.setHeat(heat));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="radiations")
    public double getRadiations() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)Registration.RADIATION_MACHINE_COMPONENT.get()).map(RadiationMachineComponent::getRadiations).orElse(0.0);
    }

    @ZenCodeType.Method
    public void addRadiations(double amount) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.RADIATION_MACHINE_COMPONENT.get()).ifPresent(component -> component.addRadiations(amount));
    }

    @ZenCodeType.Method
    public void removeRadiations(double amount, int radius) {
        this.internal.getComponentManager().getComponent((MachineComponentType)Registration.RADIATION_MACHINE_COMPONENT.get()).ifPresent(component -> component.removeRadiations(amount, radius));
    }
}

