/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.network.syncable;

import fr.frinn.custommachinery.impl.network.AbstractSyncable;
import fr.frinn.custommachinerymekanism.common.network.data.ChemicalStackData;
import fr.frinn.custommachinerymekanism.common.network.data.GasStackData;
import fr.frinn.custommachinerymekanism.common.network.data.InfusionStackData;
import fr.frinn.custommachinerymekanism.common.network.data.PigmentStackData;
import fr.frinn.custommachinerymekanism.common.network.data.SlurryStackData;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;

public abstract class ChemicalStackSyncable<C extends Chemical<C>, S extends ChemicalStack<C>, D extends ChemicalStackData<C, S>>
extends AbstractSyncable<D, S> {
    public D getData(short i) {
        ChemicalStack stack = (ChemicalStack)this.get();
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return (D)new GasStackData(i, gas);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return (D)new SlurryStackData(i, slurry);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return (D)new InfusionStackData(i, infusion);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return (D)new PigmentStackData(i, pigment);
        }
        throw new IllegalStateException("Can't get data for object: " + stack.getType().getClass().getSimpleName());
    }

    public boolean needSync() {
        ChemicalStack value = (ChemicalStack)this.get();
        boolean needSync = this.lastKnownValue != null ? !value.isStackIdentical((ChemicalStack)this.lastKnownValue) : true;
        this.lastKnownValue = value.copy();
        return needSync;
    }

    public static <C extends Chemical<C>, S extends ChemicalStack<C>, D extends ChemicalStackData<C, S>> ChemicalStackSyncable<C, S, D> create(final Supplier<S> supplier, final Consumer<S> consumer) {
        return new ChemicalStackSyncable<C, S, D>(){

            public S get() {
                return (ChemicalStack)supplier.get();
            }

            public void set(S stack) {
                consumer.accept(stack);
            }
        };
    }
}

