/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinerymekanism.common.component.handler.ChemicalComponentHandler;
import fr.frinn.custommachinerymekanism.common.requirement.ChemicalRequirement;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.network.chat.Component;

public abstract class ChemicalPerTickRequirement<C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalComponentHandler<C, S, ?, ?>>
extends ChemicalRequirement<C, S, T>
implements ITickableRequirement<T> {
    public ChemicalPerTickRequirement(RequirementIOMode mode, C chemical, long amount, String tank) {
        super(mode, chemical, amount, tank);
    }

    @Override
    public CraftingResult processStart(T handler, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(T handler, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processTick(T handler, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
            if (!this.test(handler, context)) {
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.chemical.error.input", (Object[])new Object[]{Component.m_237115_((String)this.chemical.getTranslationKey()), amount}));
            }
            ((ChemicalComponentHandler)((Object)handler)).removeFromInputs(this.tank, (Chemical)this.chemical, amount);
            return CraftingResult.success();
        }
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (!this.test(handler, context)) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.chemical.error.output", (Object[])new Object[]{amount, Component.m_237115_((String)this.chemical.getTranslationKey())}));
        }
        ((ChemicalComponentHandler)((Object)handler)).addToOutputs(this.tank, (Chemical)this.chemical, amount);
        return CraftingResult.success();
    }
}

