/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinerymekanism.common.component.handler.ChemicalComponentHandler;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.network.chat.Component;

public abstract class ChemicalRequirement<C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalComponentHandler<C, S, ?, ?>>
extends AbstractChanceableRequirement<T>
implements IJEIIngredientRequirement<S> {
    final C chemical;
    final long amount;
    final String tank;

    public static <C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalComponentHandler<C, S, ?, ?>, R extends ChemicalRequirement<C, S, T>> NamedCodec<R> makeCodec(NamedCodec<C> chemicalCodec, Function4<RequirementIOMode, C, Long, String, R> builder, String name) {
        return NamedCodec.record(fluidRequirementInstance -> fluidRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)chemicalCodec.fieldOf("chemical").forGetter(requirement -> requirement.chemical), (App)NamedCodec.LONG.fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("chance", (Object)1.0).forGetter(AbstractChanceableRequirement::getChance), (App)NamedCodec.STRING.optionalFieldOf("tank", (Object)"").forGetter(requirement -> requirement.tank)).apply((Applicative)fluidRequirementInstance, (mode, gas, amount, chance, tank) -> {
            ChemicalRequirement requirement = (ChemicalRequirement)((Object)((Object)((Object)builder.apply(mode, gas, amount, tank))));
            requirement.setChance((double)chance);
            return requirement;
        }), (String)name);
    }

    public ChemicalRequirement(RequirementIOMode mode, C chemical, long amount, String tank) {
        super(mode);
        this.chemical = chemical;
        this.amount = amount;
        this.tank = tank;
    }

    public boolean test(T handler, ICraftingContext context) {
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return ((ChemicalComponentHandler)((Object)handler)).getChemicalAmount(this.tank, this.chemical) >= amount;
        }
        return ((ChemicalComponentHandler)((Object)handler)).getSpaceForChemical(this.tank, this.chemical) >= amount;
    }

    public CraftingResult processStart(T handler, ICraftingContext context) {
        if (this.getMode() != RequirementIOMode.INPUT) {
            return CraftingResult.pass();
        }
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (!this.test(handler, context)) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.chemical.error.input", (Object[])new Object[]{Component.m_237115_((String)this.chemical.getTranslationKey()), amount}));
        }
        ((ChemicalComponentHandler)((Object)handler)).removeFromInputs(this.tank, this.chemical, amount);
        return CraftingResult.success();
    }

    public CraftingResult processEnd(T handler, ICraftingContext context) {
        if (this.getMode() != RequirementIOMode.OUTPUT) {
            return CraftingResult.pass();
        }
        long amount = (long)context.getModifiedValue((double)this.amount, (IRequirement)this, null);
        if (!this.test(handler, context)) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.chemical.error.output", (Object[])new Object[]{amount, Component.m_237115_((String)this.chemical.getTranslationKey())}));
        }
        ((ChemicalComponentHandler)((Object)handler)).addToOutputs(this.tank, this.chemical, amount);
        return CraftingResult.success();
    }
}

