/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.GasIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.handler.GasComponentHandler;
import fr.frinn.custommachinerymekanism.common.requirement.ChemicalPerTickRequirement;
import fr.frinn.custommachinerymekanism.common.utils.Codecs;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;

public class GasPerTickRequirement
extends ChemicalPerTickRequirement<Gas, GasStack, GasComponentHandler> {
    public static final NamedCodec<GasPerTickRequirement> CODEC = GasPerTickRequirement.makeCodec(Codecs.GAS, GasPerTickRequirement::new, "Gas-per-tick requirement");

    public GasPerTickRequirement(RequirementIOMode mode, Gas chemical, long amount, String tank) {
        super(mode, chemical, amount, tank);
    }

    public RequirementType<GasPerTickRequirement> getType() {
        return (RequirementType)Registration.GAS_PER_TICK_REQUIREMENT.get();
    }

    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.GAS_MACHINE_COMPONENT.get();
    }

    public List<IJEIIngredientWrapper<GasStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new GasIngredientWrapper(this.getMode(), (Gas)this.chemical, this.amount, this.getChance(), true, this.tank));
    }
}

