/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.HeatIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;
import java.util.Collections;
import java.util.List;
import mekanism.api.heat.IHeatCapacitor;
import net.minecraft.network.chat.Component;

public class HeatPerTickRequirement
extends AbstractChanceableRequirement<HeatMachineComponent>
implements ITickableRequirement<HeatMachineComponent>,
IJEIIngredientRequirement<Heat> {
    public static final NamedCodec<HeatPerTickRequirement> CODEC = NamedCodec.record(heatRequirementInstance -> heatRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("chance", (Object)1.0).forGetter(AbstractChanceableRequirement::getChance)).apply((Applicative)heatRequirementInstance, (mode, amount, chance) -> {
        HeatPerTickRequirement requirement = new HeatPerTickRequirement((RequirementIOMode)mode, (double)amount);
        requirement.setChance((double)chance);
        return requirement;
    }), (String)"Heat per tick requirement");
    private final double amount;

    public HeatPerTickRequirement(RequirementIOMode mode, double amount) {
        super(mode);
        this.amount = amount;
    }

    public RequirementType<HeatPerTickRequirement> getType() {
        return (RequirementType)Registration.HEAT_PER_TICK_REQUIREMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public boolean test(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getHeatCapacitors(null).get(0).getHeat() >= amount;
        }
        return true;
    }

    public CraftingResult processStart(HeatMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processEnd(HeatMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processTick(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        IHeatCapacitor capacitor = component.getHeatCapacitors(null).get(0);
        if (this.getMode() == RequirementIOMode.INPUT) {
            if (capacitor.getHeat() < amount) {
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.heat.error.input", (Object[])new Object[]{amount, capacitor.getHeat()}));
            }
            capacitor.handleHeat(-amount);
        } else {
            component.getHeatCapacitors(null).get(0).handleHeat(amount);
        }
        return CraftingResult.success();
    }

    public List<IJEIIngredientWrapper<Heat>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new HeatIngredientWrapper(this.getMode(), this.amount, this.getChance(), true));
    }
}

