/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.HeatIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;
import java.util.Collections;
import java.util.List;
import mekanism.api.heat.IHeatCapacitor;
import net.minecraft.network.chat.Component;

public class HeatRequirement
extends AbstractDelayedChanceableRequirement<HeatMachineComponent>
implements IJEIIngredientRequirement<Heat> {
    public static final NamedCodec<HeatRequirement> CODEC = NamedCodec.record(heatRequirementInstance -> heatRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("chance", (Object)1.0).forGetter(AbstractDelayedChanceableRequirement::getChance), (App)NamedCodec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("delay", (Object)0.0).forGetter(AbstractDelayedRequirement::getDelay)).apply((Applicative)heatRequirementInstance, (mode, amount, chance, delay) -> {
        HeatRequirement requirement = new HeatRequirement((RequirementIOMode)mode, (double)amount);
        requirement.setChance((double)chance);
        requirement.setDelay((double)delay);
        return requirement;
    }), (String)"Heat requirement");
    private final double amount;

    public HeatRequirement(RequirementIOMode mode, double amount) {
        super(mode);
        this.amount = amount;
    }

    public RequirementType<HeatRequirement> getType() {
        return (RequirementType)Registration.HEAT_REQUIREMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public boolean test(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getHeatCapacitors(null).get(0).getHeat() >= amount;
        }
        return true;
    }

    public CraftingResult processStart(HeatMachineComponent component, ICraftingContext context) {
        if (this.getMode() != RequirementIOMode.INPUT || this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        IHeatCapacitor capacitor = component.getHeatCapacitors(null).get(0);
        if (capacitor.getHeat() < amount) {
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.heat.error.input", (Object[])new Object[]{amount, capacitor.getHeat()}));
        }
        capacitor.handleHeat(-amount);
        return CraftingResult.success();
    }

    public CraftingResult processEnd(HeatMachineComponent component, ICraftingContext context) {
        if (this.getMode() != RequirementIOMode.OUTPUT || this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        component.getHeatCapacitors(null).get(0).handleHeat(amount);
        return CraftingResult.success();
    }

    public CraftingResult execute(HeatMachineComponent component, ICraftingContext context) {
        double amount = context.getModifiedValue(this.amount, (IRequirement)this, null);
        IHeatCapacitor capacitor = component.getHeatCapacitors(null).get(0);
        if (this.getMode() == RequirementIOMode.INPUT) {
            if (capacitor.getHeat() < amount) {
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.heat.error.input", (Object[])new Object[]{amount, capacitor.getHeat()}));
            }
            capacitor.handleHeat(-amount);
            return CraftingResult.success();
        }
        capacitor.handleHeat(amount);
        return CraftingResult.success();
    }

    public List<IJEIIngredientWrapper<Heat>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new HeatIngredientWrapper(this.getMode(), this.amount, this.getChance(), false));
    }
}

