/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.InfusionIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.handler.InfusionComponentHandler;
import fr.frinn.custommachinerymekanism.common.requirement.ChemicalPerTickRequirement;
import fr.frinn.custommachinerymekanism.common.utils.Codecs;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;

public class InfusionPerTickRequirement
extends ChemicalPerTickRequirement<InfuseType, InfusionStack, InfusionComponentHandler> {
    public static final NamedCodec<InfusionPerTickRequirement> CODEC = InfusionPerTickRequirement.makeCodec(Codecs.INFUSE_TYPE, InfusionPerTickRequirement::new, "Infusion-per-tick requirement");

    public InfusionPerTickRequirement(RequirementIOMode mode, InfuseType chemical, long amount, String tank) {
        super(mode, chemical, amount, tank);
    }

    public RequirementType<InfusionPerTickRequirement> getType() {
        return (RequirementType)Registration.INFUSION_PER_TICK_REQUIREMENT.get();
    }

    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get();
    }

    public List<IJEIIngredientWrapper<InfusionStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new InfusionIngredientWrapper(this.getMode(), (InfuseType)this.chemical, this.amount, this.getChance(), true, this.tank));
    }
}

