/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.InfusionIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.handler.InfusionComponentHandler;
import fr.frinn.custommachinerymekanism.common.requirement.ChemicalRequirement;
import fr.frinn.custommachinerymekanism.common.utils.Codecs;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;

public class InfusionRequirement
extends ChemicalRequirement<InfuseType, InfusionStack, InfusionComponentHandler> {
    public static final NamedCodec<InfusionRequirement> CODEC = InfusionRequirement.makeCodec(Codecs.INFUSE_TYPE, InfusionRequirement::new, "Infusion requirement");

    public InfusionRequirement(RequirementIOMode mode, InfuseType chemical, long amount, String tank) {
        super(mode, chemical, amount, tank);
    }

    public RequirementType<InfusionRequirement> getType() {
        return (RequirementType)Registration.INFUSION_REQUIREMENT.get();
    }

    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.INFUSION_MACHINE_COMPONENT.get();
    }

    public List<IJEIIngredientWrapper<InfusionStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new InfusionIngredientWrapper(this.getMode(), (InfuseType)this.chemical, this.amount, this.getChance(), false, this.tank));
    }
}

