/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.RadiationMachineComponent;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.network.chat.Component;

public class RadiationPerTickRequirement
extends AbstractChanceableRequirement<RadiationMachineComponent>
implements ITickableRequirement<RadiationMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<RadiationPerTickRequirement> CODEC = NamedCodec.record(radiationRequirementInstance -> radiationRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("range", () -> MekanismConfig.general.radiationChunkCheckRadius.get() * 16).forGetter(requirement -> requirement.radius), (App)NamedCodec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("chance", (Object)1.0).forGetter(AbstractChanceableRequirement::getChance)).apply((Applicative)radiationRequirementInstance, (mode, amount, radius, chance) -> {
        RadiationPerTickRequirement requirement = new RadiationPerTickRequirement((RequirementIOMode)mode, (double)amount, (int)radius);
        requirement.setChance((double)chance);
        return requirement;
    }), (String)"Radiation per tick requirement");
    private final double amount;
    private final int radius;

    public RadiationPerTickRequirement(RequirementIOMode mode, double amount, int radius) {
        super(mode);
        this.amount = amount;
        this.radius = radius;
    }

    public RequirementType<RadiationPerTickRequirement> getType() {
        return (RequirementType)Registration.RADIATION_PER_TICK.get();
    }

    public MachineComponentType<RadiationMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.RADIATION_MACHINE_COMPONENT.get();
    }

    public boolean test(RadiationMachineComponent component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getRadiations() >= this.amount;
        }
        return true;
    }

    public CraftingResult processStart(RadiationMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processEnd(RadiationMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processTick(RadiationMachineComponent component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            double radiations = component.getRadiations();
            if (radiations < this.amount) {
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.radiation.error", (Object[])new Object[]{RadiationPerTickRequirement.sievert(radiations), RadiationPerTickRequirement.sievert(this.amount)}));
            }
            component.removeRadiations(this.amount, this.radius);
        } else {
            component.addRadiations(this.amount);
        }
        return CraftingResult.success();
    }

    public void getDisplayInfo(IDisplayInfo info) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            info.setItemIcon(MekanismItems.GEIGER_COUNTER.m_5456_());
            info.addTooltip((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.radiation.info.tick.input", (Object[])new Object[]{RadiationPerTickRequirement.sievert(this.amount), this.radius}));
        } else {
            info.setItemIcon(MekanismItems.GEIGER_COUNTER.m_5456_());
            info.addTooltip((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.radiation.info.tick.output", (Object[])new Object[]{RadiationPerTickRequirement.sievert(this.amount)}));
        }
    }

    private static Component sievert(double amount) {
        return Component.m_237113_((String)"").m_7220_(UnitDisplayUtils.getDisplayShort((double)amount, (UnitDisplayUtils.RadiationUnit)UnitDisplayUtils.RadiationUnit.SV, (int)3)).m_130948_(RadiationManager.RadiationScale.getSeverityColor((double)amount).getColoredName().m_7383_());
    }
}

