/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.SlurryIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.handler.SlurryComponentHandler;
import fr.frinn.custommachinerymekanism.common.requirement.ChemicalPerTickRequirement;
import fr.frinn.custommachinerymekanism.common.utils.Codecs;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;

public class SlurryPerTickRequirement
extends ChemicalPerTickRequirement<Slurry, SlurryStack, SlurryComponentHandler> {
    public static final NamedCodec<SlurryPerTickRequirement> CODEC = SlurryPerTickRequirement.makeCodec(Codecs.SLURRY, SlurryPerTickRequirement::new, "Slurry-per-tick requirement");

    public SlurryPerTickRequirement(RequirementIOMode mode, Slurry chemical, long amount, String tank) {
        super(mode, chemical, amount, tank);
    }

    public RequirementType<SlurryPerTickRequirement> getType() {
        return (RequirementType)Registration.SLURRY_PER_TICK_REQUIREMENT.get();
    }

    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.SLURRY_MACHINE_COMPONENT.get();
    }

    public List<IJEIIngredientWrapper<SlurryStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new SlurryIngredientWrapper(this.getMode(), (Slurry)this.chemical, this.amount, this.getChance(), true, this.tank));
    }
}

