/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import fr.frinn.custommachinerymekanism.client.jei.wrapper.TemperatureIngredientWrapper;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;
import java.util.Collections;
import java.util.List;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.network.chat.Component;

public class TemperatureRequirement
extends AbstractRequirement<HeatMachineComponent>
implements ITickableRequirement<HeatMachineComponent>,
IJEIIngredientRequirement<Heat> {
    public static final NamedCodec<TemperatureRequirement> CODEC = NamedCodec.record(temperatureRequirementInstance -> temperatureRequirementInstance.group((App)IntRange.CODEC.fieldOf("temperature").forGetter(requirement -> requirement.temp), (App)NamedCodec.enumCodec(UnitDisplayUtils.TemperatureUnit.class).optionalFieldOf("unit", (Object)UnitDisplayUtils.TemperatureUnit.KELVIN).forGetter(requirement -> requirement.unit)).apply((Applicative)temperatureRequirementInstance, TemperatureRequirement::new), (String)"Temperature requirement");
    private final IntRange temp;
    private final UnitDisplayUtils.TemperatureUnit unit;

    public TemperatureRequirement(IntRange temp, UnitDisplayUtils.TemperatureUnit unit) {
        super(RequirementIOMode.INPUT);
        this.temp = temp;
        this.unit = unit;
    }

    public RequirementType<TemperatureRequirement> getType() {
        return (RequirementType)Registration.TEMPERATURE_REQUIREMENT.get();
    }

    public MachineComponentType<HeatMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public boolean test(HeatMachineComponent component, ICraftingContext context) {
        return this.temp.contains((Comparable)Integer.valueOf((int)this.unit.convertFromK(component.getTemperature(0), true)));
    }

    public CraftingResult processStart(HeatMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processEnd(HeatMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    public CraftingResult processTick(HeatMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.m_237110_((String)"custommachinerymekanism.requirements.temp.error", (Object[])new Object[]{this.temp.toFormattedString() + this.unit.getSymbol()}));
    }

    public List<IJEIIngredientWrapper<Heat>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new TemperatureIngredientWrapper(this.temp, this.unit));
    }
}

