/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.transfer;

import fr.frinn.custommachinery.impl.component.config.SideMode;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import fr.frinn.custommachinerymekanism.common.component.handler.ChemicalComponentHandler;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public abstract class SidedChemicalTank<C extends Chemical<C>, S extends ChemicalStack<C>, T extends ChemicalMachineComponent<C, S>, H extends ChemicalComponentHandler<C, S, ?, T>>
implements IChemicalHandler<C, S> {
    private final H handler;
    @Nullable
    private final Direction side;

    public SidedChemicalTank(H handler, @Nullable Direction side) {
        this.handler = handler;
        this.side = side;
    }

    public int getTanks() {
        return this.handler.getComponents().size();
    }

    public S getChemicalInTank(int i) {
        return ((ChemicalMachineComponent)((Object)this.handler.getComponents().get(i))).getStack();
    }

    public void setChemicalInTank(int i, S stack) {
        ((ChemicalMachineComponent)((Object)this.handler.getComponents().get(i))).setStack(stack);
    }

    public long getTankCapacity(int i) {
        return ((ChemicalMachineComponent)((Object)this.handler.getComponents().get(i))).getCapacity();
    }

    public boolean isValid(int i, S stack) {
        return ((ChemicalMachineComponent)((Object)this.handler.getComponents().get(i))).isValid(stack);
    }

    public S insertChemical(int i, S stack, Action action) {
        ChemicalMachineComponent component = (ChemicalMachineComponent)((Object)this.handler.getComponents().get(i));
        if (!this.getMode(component).isInput()) {
            return stack;
        }
        return component.insert(stack, action, false);
    }

    public S extractChemical(int i, long amount, Action action) {
        ChemicalMachineComponent component = (ChemicalMachineComponent)((Object)this.handler.getComponents().get(i));
        if (!this.getMode(component).isOutput()) {
            return component.empty();
        }
        return component.extract(amount, action, false);
    }

    private SideMode getMode(T component) {
        if (this.side == null) {
            return SideMode.BOTH;
        }
        return ((ChemicalMachineComponent)((Object)component)).getConfig().getSideMode(this.side);
    }
}

