/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiItemStack
extends GuiElement<GuiItemStack>
implements BackgroundRender {
    private Supplier<ItemStack> stack;
    private Supplier<Boolean> decorate = () -> true;
    private Supplier<Boolean> toolTip = () -> true;

    public GuiItemStack(@NotNull GuiParent<?> parent) {
        this(parent, () -> ItemStack.f_41583_);
    }

    public GuiItemStack(@NotNull GuiParent<?> parent, ItemStack itemStack) {
        super(parent);
        this.setStack(itemStack);
    }

    public GuiItemStack(@NotNull GuiParent<?> parent, Supplier<ItemStack> provider) {
        super(parent);
        this.setStack(provider);
    }

    public GuiItemStack setStack(Supplier<ItemStack> stackProvider) {
        this.stack = stackProvider;
        return this;
    }

    public GuiItemStack setStack(ItemStack stack) {
        this.stack = () -> stack;
        return this;
    }

    public GuiItemStack enableStackDecoration(boolean enableDecoration) {
        return this.enableStackDecoration(() -> enableDecoration);
    }

    public GuiItemStack enableStackDecoration(Supplier<Boolean> enableDecoration) {
        this.decorate = enableDecoration;
        return this;
    }

    public GuiItemStack enableStackToolTip(boolean enableToolTip) {
        return this.enableStackToolTip(() -> enableToolTip);
    }

    public GuiItemStack enableStackToolTip(Supplier<Boolean> enableToolTip) {
        this.toolTip = enableToolTip;
        return this;
    }

    public double getStackSize() {
        return Math.max(this.getValue(GeoParam.WIDTH), this.getValue(GeoParam.HEIGHT));
    }

    @Override
    public double getBackgroundDepth() {
        return this.getStackSize();
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        ItemStack stack = this.stack.get();
        if (stack.m_41619_()) {
            return;
        }
        render.renderItem(stack, this.xMin(), this.yMin(), this.getStackSize(), (int)(this.xMin() + this.xSize() * this.yMin()));
        if (this.decorate.get().booleanValue()) {
            render.renderItemDecorations(stack, this.xMin(), this.yMin(), this.getStackSize());
        }
    }

    @Override
    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        if (super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed)) {
            return true;
        }
        if (this.isMouseOver() && !this.stack.get().m_41619_()) {
            render.renderTooltip(this.stack.get(), mouseX, mouseY);
            return true;
        }
        return false;
    }
}

