/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.mekanism.gear;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.compat.mekanism.AddonMekanismConfig;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.OxygenCanItem;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.Map;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;

public class ModuleOxygenProofUnit
implements ICustomModule<ModuleOxygenProofUnit> {
    public static final ResourceLocation ICON = AdAstraGiselleAddon.rl(MekanismUtils.ResourceType.GUI_HUD.getPrefix() + "space_breathing_unit.png");
    private int oxygenDuration = 0;
    private FloatingLong energyUsingProvide;
    private FloatingLong energyUsingProduce;

    public void init(IModule<ModuleOxygenProofUnit> module, ModuleConfigItemCreator configItemCreator) {
        super.init(module, configItemCreator);
        this.oxygenDuration = 30;
        this.energyUsingProvide = FloatingLong.create((long)AddonMekanismConfig.MODULES_OXYGEN_PROOF_ENERGY_USING_PROVIDE);
        this.energyUsingProduce = FloatingLong.create((long)AddonMekanismConfig.MODULES_OXYGEN_PROOF_ENERGY_USING_PRODUCE);
    }

    public void tickServer(IModule<ModuleOxygenProofUnit> module, Player player) {
        super.tickServer(module, player);
        this.produceOxygen(module, player);
    }

    private void produceOxygen(IModule<ModuleOxygenProofUnit> module, Player player) {
        long productionRate = this.getProduceRate(module, player);
        if (productionRate == 0L) {
            return;
        }
        FloatingLong energyUsing = this.getEnergyUsingProduce();
        long productionRateFirst = productionRate = Math.min(productionRate, (long)module.getContainerEnergy().divideToInt(energyUsing));
        ItemStack handStack = player.m_6844_(EquipmentSlot.MAINHAND);
        IGasHandler handCapability = (IGasHandler)handStack.getCapability(Capabilities.GAS_HANDLER).orElse(null);
        if (handCapability != null) {
            GasStack remain = (GasStack)handCapability.insertChemical((ChemicalStack)MekanismGases.OXYGEN.getStack(productionRate), Action.EXECUTE);
            productionRate = remain.getAmount();
        }
        productionRate = this.fillOxygenCan(player, productionRate);
        long oxygenUsed = productionRateFirst - productionRate;
        FloatingLong multiply = energyUsing.multiply(oxygenUsed);
        if (!player.m_9236_().m_5776_()) {
            module.useEnergy((LivingEntity)player, multiply);
        }
        int airSupply = player.m_20146_();
        int airFill = (int)Math.min(productionRateFirst, (long)(player.m_6062_() - airSupply));
        player.m_20301_(airSupply + airFill);
    }

    public long fillOxygenCan(Player player, long productionRate) {
        for (ItemStackReference item : LivingHelper.getSlotItems((LivingEntity)player)) {
            if (productionRate <= 0L) break;
            if (!(item.getStack().m_41720_() instanceof OxygenCanItem)) continue;
            UniveralFluidHandler tank = UniveralFluidHandler.from(item);
            FluidHolder containedStack = tank.getFluidInTank(0);
            Fluid insertingFluid = (Fluid)ModFluids.OXYGEN.get();
            if (!containedStack.isEmpty()) {
                insertingFluid = containedStack.getFluid();
            }
            FluidHolder inserting = FluidHooks.newFluidHolder((Fluid)insertingFluid, (long)productionRate, null);
            long inserted = tank.insertFluid(inserting, false);
            productionRate -= inserted;
        }
        return productionRate;
    }

    public long getProduceRate(IModule<ModuleOxygenProofUnit> module, Player player) {
        float eyeHeight = player.m_20192_();
        Map fluidsIn = MekanismUtils.getFluidsIn((Player)player, bb -> {
            double centerX = (bb.f_82288_ + bb.f_82291_) / 2.0;
            double centerZ = (bb.f_82290_ + bb.f_82293_) / 2.0;
            return new AABB(centerX, Math.min(bb.f_82289_ + (double)eyeHeight - 0.27, bb.f_82292_), centerZ, centerX, Math.min(bb.f_82289_ + (double)eyeHeight - 0.14, bb.f_82292_), centerZ);
        });
        if (fluidsIn.entrySet().stream().anyMatch(entry -> entry.getKey() == ForgeMod.WATER_TYPE.get() && ((MekanismUtils.FluidInDetails)entry.getValue()).getMaxHeight() >= 0.11)) {
            return this.getMaxProduceRate(module);
        }
        if (player.m_20070_()) {
            return this.getMaxProduceRate(module) / 2L;
        }
        return 0L;
    }

    public boolean useResources(IModule<ModuleOxygenProofUnit> module, LivingEntity living, boolean simulate) {
        FloatingLong energyUsing;
        UniveralFluidHandler fluidHandler;
        long oxygenUsing = ProofAbstractUtils.OXYGEN_PROOF_USING;
        IOxygenCharger oxygenCharger = OxygenChargerUtils.firstExtractable(living, oxygenUsing);
        if (oxygenCharger != null && FluidHooks2.extractFluid(fluidHandler = oxygenCharger.getFluidHandler(), FluidPredicates::isOxygen, oxygenUsing, true).getFluidAmount() >= oxygenUsing && module.canUseEnergy(living, energyUsing = this.getEnergyUsingProvide())) {
            if (!simulate && !living.m_9236_().m_5776_()) {
                FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, false);
                module.useEnergy(living, energyUsing);
            }
            return true;
        }
        return false;
    }

    public void addHUDElements(IModule<ModuleOxygenProofUnit> module, Player player, Consumer<IHUDElement> hudElementAdder) {
        super.addHUDElements(module, player, hudElementAdder);
        if (!module.isEnabled()) {
            return;
        }
        double ratio = OxygenChargerUtils.getExtractableStoredRatio((LivingEntity)player).orElse(0.0);
        hudElementAdder.accept(MekanismAPI.getModuleHelper().hudElementPercent(ICON, ratio));
    }

    public long getMaxProduceRate(IModule<ModuleOxygenProofUnit> module) {
        return (long)Math.pow(2.0, module.getInstalledCount() - 1);
    }

    public int getOxygenDuration() {
        return this.oxygenDuration;
    }

    public FloatingLong getEnergyUsingProvide() {
        return this.energyUsingProvide;
    }

    public FloatingLong getEnergyUsingProduce() {
        return this.energyUsingProduce;
    }
}

